/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorFeature;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.hibernate.HibernateFeature;
import net.krotscheck.kangaroo.common.httpClient.HttpClientFeature;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;

public final class AuthenticatorFeatureTest
extends ContainerTest {
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(HttpClientFeature.class);
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(HibernateFeature.class);
        a.register(AuthenticatorFeature.class);
        a.register(MockService.class);
        return a;
    }

    @Test
    public void testStatus() {
        Response response = this.target("/").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Path(value="/")
    public static final class MockService {
        private InjectionManager locator;

        @Inject
        public MockService(InjectionManager injector) {
            this.locator = injector;
        }

        @GET
        @Produces(value={"application/json"})
        public Response status() {
            for (AuthenticatorType t : AuthenticatorType.values()) {
                IAuthenticator authenticator = (IAuthenticator)this.locator.getInstance(IAuthenticator.class, t.name());
                Assert.assertNotNull((Object)authenticator);
            }
            List authenticators = this.locator.getAllInstances(IAuthenticator.class);
            Assert.assertEquals((long)AuthenticatorType.values().length, (long)authenticators.size());
            return Response.status((int)200).build();
        }
    }
}

