/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator;

import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.rule.SeleniumRule;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.test.runner.SingleInstanceTestRunner;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.hibernate.Session;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=SingleInstanceTestRunner.class)
public abstract class AbstractBrowserLoginTest
extends ContainerTest {
    @ClassRule
    public static final SeleniumRule SELENIUM = new SeleniumRule();
    protected static final Integer TIMEOUT = 20;
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private SingletonTestContainerFactory testContainerFactory;
    private ResourceConfig testApplication;

    public static ApplicationBuilder.ApplicationContext getContext() {
        return context;
    }

    protected final TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    protected final ResourceConfig createApplication() {
        if (this.testApplication == null) {
            this.testApplication = new OAuthAPI();
        }
        return this.testApplication;
    }

    protected final DeploymentContext configureDeployment() {
        this.forceSet("jersey.config.test.container.port", TestConfig.getTestingPort());
        this.forceSet("jersey.config.test.logging.enable", "true");
        this.forceSet("jersey.config.test.logging.dumpEntity", "true");
        return ServletDeploymentContext.forServlet((HttpServlet)new ServletContainer(this.createApplication())).build();
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                HashMap<String, String> googleConfig = new HashMap<String, String>();
                googleConfig.put("client_id", TestConfig.getGoogleAppId());
                googleConfig.put("client_secret", TestConfig.getGoogleAppSecret());
                HashMap<String, String> fbConfig = new HashMap<String, String>();
                fbConfig.put("client_id", TestConfig.getFacebookAppId());
                fbConfig.put("client_secret", TestConfig.getFacebookAppSecret());
                context = ApplicationBuilder.newApplication(session).scope("debug").scope("debug1").role("test", new String[]{"debug", "debug1"}).client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Google, googleConfig).authenticator(AuthenticatorType.Facebook, fbConfig).redirect("https://www.example.com/").build();
            }
        };
    }
}

