/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.test.rule;

import java.math.BigInteger;
import java.util.ArrayList;
import net.krotscheck.kangaroo.authz.admin.Scope;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.test.rule.HibernateResource;
import org.apache.commons.configuration.Configuration;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public final class TestDataResource
extends net.krotscheck.kangaroo.test.rule.TestDataResource {
    private ApplicationBuilder.ApplicationContext adminContext;
    private ApplicationBuilder.ApplicationContext secondContext;
    private Configuration systemConfig;

    public TestDataResource(HibernateResource factoryProvider) {
        super(factoryProvider);
    }

    public ApplicationBuilder.ApplicationContext getAdminApplication() {
        return this.adminContext;
    }

    public ApplicationBuilder.ApplicationContext getSecondaryApplication() {
        return this.secondContext;
    }

    public Configuration getSystemConfiguration() {
        return this.systemConfig;
    }

    private BigInteger createAdminApplication() {
        SessionFactory factory = this.getSessionFactory();
        ServletConfigFactory configFactory = new ServletConfigFactory(factory);
        this.systemConfig = configFactory.get();
        FirstRunContainerLifecycleListener listener = new FirstRunContainerLifecycleListener(factory, this.systemConfig, new DatabaseMigrationState());
        listener.onStartup(null);
        listener.onShutdown(null);
        return IdUtil.fromString((String)this.systemConfig.getString("application_id"));
    }

    protected void loadTestData(Session session) {
        BigInteger adminAppId = this.createAdminApplication();
        ApplicationBuilder adminBuilder = ApplicationBuilder.fromApplication(session, adminAppId).user().identity();
        ApplicationBuilder.ApplicationContext initialContext = adminBuilder.build();
        this.applyUsersToClient(adminBuilder);
        this.buildApplicationData(adminBuilder);
        this.adminContext = adminBuilder.build();
        ApplicationBuilder secondBuilder = ApplicationBuilder.newApplication(session).owner(initialContext.getUser()).scopes(Scope.allScopes());
        this.buildApplicationData(secondBuilder);
        this.secondContext = secondBuilder.build();
        ArrayList<Application> applications = new ArrayList<Application>();
        for (int i = 0; i < 10; ++i) {
            String appName = String.format("Application %s- %s", i, i % 2 == 0 ? "many" : "frown");
            Application one = new Application();
            one.setName(appName);
            one.setOwner(this.adminContext.getOwner());
            applications.add(one);
            Application two = new Application();
            two.setName(appName);
            two.setOwner(this.secondContext.getOwner());
            applications.add(two);
        }
        Application singleOne = new Application();
        singleOne.setName("Single");
        singleOne.setOwner(this.adminContext.getOwner());
        applications.add(singleOne);
        Application singleTwo = new Application();
        singleTwo.setName("Single");
        singleTwo.setOwner(this.secondContext.getOwner());
        applications.add(singleTwo);
        session.getTransaction().begin();
        applications.forEach(arg_0 -> ((Session)session).save(arg_0));
        session.getTransaction().commit();
    }

    private void buildApplicationData(ApplicationBuilder builder) {
        builder.scope("Single Scope").scope("Second Scope - many").scope("Third Scope - many").scope("Fourth Scope - many");
        builder.role("Single Role").role("Second Role - many").role("Third Role - many").role("Fourth Role - many");
        builder.client(ClientType.ClientCredentials, "Single client").authenticator(AuthenticatorType.Test);
        builder.client(ClientType.OwnerCredentials, "Second client - many").authenticator(AuthenticatorType.Password);
        this.applyUsersToClient(builder);
        builder.client(ClientType.Implicit, "Third client - many").authenticator(AuthenticatorType.Password);
        this.applyUsersToClient(builder);
        builder.client(ClientType.AuthorizationGrant, "Fourth client - many").authenticator(AuthenticatorType.Password);
        this.applyUsersToClient(builder);
    }

    private void applyUsersToClient(ApplicationBuilder builder) {
        builder.user().identity().claim("name", "Single User").redirect("http://single.token.example.com/").referrer("http://single.token.example.com/").authToken().bearerToken();
        builder.user().identity().claim("name", "Second User - many").redirect("http://second.token.example.com/many").referrer("http://second.token.example.com/many").authToken().bearerToken();
        builder.user().identity().claim("name", "Third User - many").redirect("http://third.token.example.com/many").referrer("http://third.token.example.com/many").authToken().bearerToken();
        builder.user().identity().claim("name", "Fourth User - many").redirect("http://fourth.token.example.com/many").referrer("http://fourth.token.example.com/many").authToken().bearerToken();
    }
}

