/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.servlet;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Properties;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.config.HibernateConfiguration;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.glassfish.jersey.server.spi.Container;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class FirstRunContainerLifecycleListenerTest
extends DatabaseTest {
    @Test
    public void assertOnlyRunOnce() {
        Properties p = new Properties();
        p.put("first_run", (Object)true);
        MapConfiguration test = new MapConfiguration(p);
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Container mockContainer = (Container)Mockito.mock(Container.class);
        FirstRunContainerLifecycleListener l = new FirstRunContainerLifecycleListener(mockFactory, (Configuration)test, new DatabaseMigrationState());
        l.onStartup(mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContainer});
    }

    @Test
    public void assertBootstrapSuccessful() {
        HibernateConfiguration testConfig = new HibernateConfiguration(this.getSessionFactory(), "kangaroo-servlet-admin");
        Container mockContainer = (Container)Mockito.mock(Container.class);
        FirstRunContainerLifecycleListener l = new FirstRunContainerLifecycleListener(this.getSessionFactory(), (Configuration)testConfig, new DatabaseMigrationState());
        l.onStartup(mockContainer);
        Session s = this.getSession();
        String appId = testConfig.getString("application_id");
        BigInteger appByte = IdUtil.fromString((String)appId);
        Assert.assertNotNull((Object)appByte);
        Application application = (Application)s.get(Application.class, (Serializable)appByte);
        Assert.assertNotNull((Object)application);
        String clientId = testConfig.getString("application_client_id");
        BigInteger clientByte = IdUtil.fromString((String)clientId);
        Assert.assertNotNull((Object)clientByte);
        Client client = (Client)s.get(Client.class, (Serializable)clientByte);
        Assert.assertNotNull((Object)client);
        String adminId = testConfig.getString("application_admin_id");
        BigInteger adminByte = IdUtil.fromString((String)adminId);
        Assert.assertNotNull((Object)adminByte);
        User user = (User)s.get(User.class, (Serializable)adminByte);
        Assert.assertNotNull((Object)user);
        testConfig.clear();
    }

    @Test
    public void assertReloadShutdownNoInteraction() {
        Properties p = new Properties();
        p.put("first_run", (Object)true);
        MapConfiguration test = new MapConfiguration(p);
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Container mockContainer = (Container)Mockito.mock(Container.class);
        FirstRunContainerLifecycleListener l = new FirstRunContainerLifecycleListener(this.getSessionFactory(), (Configuration)test, new DatabaseMigrationState());
        l.onShutdown(mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContainer});
        l.onReload(mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContainer});
    }
}

