/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class UserServiceCRUDTest
extends AbstractServiceCRUDTest<User> {
    private static final GenericType<ListResponseEntity<User>> LIST_TYPE = new GenericType<ListResponseEntity<User>>(){};

    public UserServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(User.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:user_admin", false, true}, {ClientType.Implicit, "kangaroo:user", false, true}, {ClientType.Implicit, "kangaroo:user_admin", true, true}, {ClientType.Implicit, "kangaroo:user", true, false}, {ClientType.ClientCredentials, "kangaroo:user_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:user", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<User>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected User getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getUser();
    }

    @Override
    protected User getNewEntity() {
        return new User();
    }

    @Override
    protected User createValidEntity(ApplicationBuilder.ApplicationContext context) {
        User newUser = new User();
        newUser.setApplication(context.getApplication());
        newUser.setRole(context.getRole());
        return newUser;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:user_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:user";
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/user/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testPostNoParent() throws Exception {
        User testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setApplication(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPut() throws Exception {
        User entity = this.getEntity(this.getAdminContext());
        Role role = this.getAdminContext().getRole();
        entity.setRole(role);
        entity.setApplication(this.getAdminContext().getApplication());
        Response r = this.putEntity((AbstractAuthzEntity)entity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            User response = (User)r.readEntity(User.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)entity, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeParentEntity() throws Exception {
        Application newParent = this.getAdminContext().getApplication();
        User entity = this.getEntity(this.getSecondaryContext());
        User user = new User();
        user.setId(entity.getId());
        user.setApplication(newParent);
        user.setRole(entity.getRole());
        Response r = this.putEntity((AbstractAuthzEntity)user, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)entity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

