/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class UserServiceBrowseTest
extends AbstractServiceBrowseTest<User> {
    private static final GenericType<ListResponseEntity<User>> LIST_TYPE = new GenericType<ListResponseEntity<User>>(){};

    public UserServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:user_admin", false}, {ClientType.Implicit, "kangaroo:user", false}, {ClientType.Implicit, "kangaroo:user_admin", true}, {ClientType.Implicit, "kangaroo:user", true}, {ClientType.ClientCredentials, "kangaroo:user_admin", false}, {ClientType.ClientCredentials, "kangaroo:user", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:user_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:user";
    }

    @Override
    protected GenericType<ListResponseEntity<User>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<User> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria c = this.getSession().createCriteria(Application.class);
        return c.list().stream().flatMap(a -> a.getUsers().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected List<User> getOwnedEntities(User owner) {
        return owner.getApplications().stream().flatMap(a -> a.getUsers().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/user/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseFilterByApplication() {
        Application filtered = this.getAdminContext().getApplication();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("application", IdUtil.toString((BigInteger)filtered.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(user -> user.getApplication().equals((Object)filtered)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)filtered, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByInvalidApplication() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.browse(params, this.getAdminToken());
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByRole() {
        Role filtered = (Role)this.getAdminContext().getApplication().getRoles().stream().filter(role -> role.getName().equals("admin")).collect(Collectors.toList()).get(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("role", IdUtil.toString((BigInteger)filtered.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(user -> user.getRole() != null).filter(user -> user.getRole().equals((Object)filtered)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)filtered, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByInvalidRole() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("role", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.browse(params, this.getAdminToken());
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }
}

