/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class UserIdentityServiceSearchTest
extends AbstractServiceSearchTest<UserIdentity> {
    private static final GenericType<ListResponseEntity<UserIdentity>> LIST_TYPE = new GenericType<ListResponseEntity<UserIdentity>>(){};

    public UserIdentityServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(UserIdentity.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:identity_admin", false}, {ClientType.Implicit, "kangaroo:identity", false}, {ClientType.Implicit, "kangaroo:identity_admin", true}, {ClientType.Implicit, "kangaroo:identity", true}, {ClientType.ClientCredentials, "kangaroo:identity_admin", false}, {ClientType.ClientCredentials, "kangaroo:identity", false});
    }

    @Override
    protected GenericType<ListResponseEntity<UserIdentity>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<UserIdentity> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getUsers().stream()).flatMap(u -> u.getIdentities().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"claims", "remoteId"};
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:identity_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:identity";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/identity/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testSearchByUser() {
        String query = "many";
        List searchResults = this.getSearchResults(query);
        User user = (User)searchResults.stream().map(i -> i.getUser()).distinct().collect(Collectors.toList()).get(0);
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("user", IdUtil.toString((BigInteger)user.getId()));
        Response r = this.search(params, token);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getUser().equals((Object)user)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)user, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidUser() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("user", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedUser() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("user", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSearchByType() {
        String query = "many";
        Authenticator authenticator = this.getSecondaryContext().getAuthenticator();
        AuthenticatorType type = authenticator.getType();
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("type", type.toString());
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getType().equals((Object)type)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidType() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("type", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

