/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class UserIdentityServiceCRUDTest
extends AbstractServiceCRUDTest<UserIdentity> {
    private static final GenericType<ListResponseEntity<UserIdentity>> LIST_TYPE = new GenericType<ListResponseEntity<UserIdentity>>(){};

    public UserIdentityServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(UserIdentity.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:identity_admin", false, true}, {ClientType.Implicit, "kangaroo:identity", false, true}, {ClientType.Implicit, "kangaroo:identity_admin", true, true}, {ClientType.Implicit, "kangaroo:identity", true, false}, {ClientType.ClientCredentials, "kangaroo:identity_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:identity", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<UserIdentity>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/identity/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Override
    protected UserIdentity getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getUserIdentity();
    }

    @Override
    protected UserIdentity getNewEntity() {
        return new UserIdentity();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:identity_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:identity";
    }

    @Override
    protected UserIdentity createValidEntity(ApplicationBuilder.ApplicationContext context) {
        UserIdentity identity = new UserIdentity();
        identity.setRemoteId(IdUtil.toString((BigInteger)IdUtil.next()));
        identity.setPassword(IdUtil.toString((BigInteger)IdUtil.next()));
        identity.setUser(context.getUser());
        identity.getClaims().put("foo", "bar");
        identity.getClaims().put("lol", "cat");
        Authenticator authenticator = (Authenticator)this.getAttached(context.getApplication()).getClients().stream().flatMap(c -> c.getAuthenticators().stream()).filter(a -> a.getType().equals((Object)AuthenticatorType.Password)).collect(Collectors.toList()).get(0);
        identity.setType(authenticator.getType());
        return identity;
    }

    @Test
    public void testGetNoPasswordSalt() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().user().login("foo", "bar").build();
        UserIdentity testingEntity = testContext.getUserIdentity();
        Assert.assertNotNull((Object)testingEntity.getPassword());
        Assert.assertNotNull((Object)testingEntity.getSalt());
        Response r = this.getEntity((AbstractAuthzEntity)testingEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            UserIdentity response = (UserIdentity)r.readEntity(UserIdentity.class);
            Assert.assertEquals((Object)testingEntity.getId(), (Object)response.getId());
            Assert.assertNull((Object)response.getPassword());
            Assert.assertNull((Object)response.getSalt());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPostNoPasswordSalt() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            UserIdentity response = (UserIdentity)getResponse.readEntity(UserIdentity.class);
            Assert.assertNull((Object)response.getPassword());
            Assert.assertNull((Object)response.getSalt());
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostEncryptPassword() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            UserIdentity response = (UserIdentity)getResponse.readEntity(UserIdentity.class);
            Assert.assertNull((Object)response.getPassword());
            Assert.assertNull((Object)response.getSalt());
            this.getSession().createCriteria(UserIdentity.class).list();
            this.getSession().getTransaction().begin();
            UserIdentity dbEntity = (UserIdentity)this.getSession().byId(UserIdentity.class).load((Serializable)response.getId());
            Assert.assertNotNull((Object)dbEntity.getPassword());
            Assert.assertNotNull((Object)dbEntity.getSalt());
            Assert.assertEquals((Object)dbEntity.getPassword(), (Object)PasswordUtil.hash((String)testEntity.getPassword(), (String)dbEntity.getSalt()));
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostWrongAuthenticator() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext().getBuilder().authenticator(AuthenticatorType.Test).build();
        UserIdentity testEntity = this.createValidEntity(context);
        testEntity.setType(context.getAuthenticator().getType());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoAuthenticator() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setType(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostInvalidUser() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        User invalidUser = new User();
        invalidUser.setId(IdUtil.next());
        testEntity.setUser(invalidUser);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoUser() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setUser(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoRemoteId() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setRemoteId(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoPassword() throws Exception {
        UserIdentity testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setPassword(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPutNoPasswordSalt() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext().getBuilder().user().login("test", "password").build();
        UserIdentity testEntity = context.getUserIdentity();
        testEntity.setPassword("OMG PASSWORD");
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            UserIdentity response = (UserIdentity)r.readEntity(UserIdentity.class);
            Assert.assertNull((Object)response.getPassword());
            Assert.assertNull((Object)response.getSalt());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeType() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext().getBuilder().authenticator(AuthenticatorType.Test).user().login("test", "password").build();
        UserIdentity testEntity = context.getUserIdentity();
        testEntity.setType(AuthenticatorType.Password);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeUser() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext().getBuilder().user().login("test", "password").user().build();
        UserIdentity originalEntity = context.getUserIdentity();
        User newUser = context.getUser();
        UserIdentity testEntity = (UserIdentity)originalEntity.clone();
        testEntity.setUser(newUser);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)originalEntity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

