/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class UserIdentityServiceBrowseTest
extends AbstractServiceBrowseTest<UserIdentity> {
    private static final GenericType<ListResponseEntity<UserIdentity>> LIST_TYPE = new GenericType<ListResponseEntity<UserIdentity>>(){};

    public UserIdentityServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:identity_admin", false}, {ClientType.Implicit, "kangaroo:identity", false}, {ClientType.Implicit, "kangaroo:identity_admin", true}, {ClientType.Implicit, "kangaroo:identity", true}, {ClientType.ClientCredentials, "kangaroo:identity_admin", false}, {ClientType.ClientCredentials, "kangaroo:identity", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:identity_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:identity";
    }

    @Override
    protected GenericType<ListResponseEntity<UserIdentity>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<UserIdentity> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria c = this.getSession().createCriteria(Application.class);
        return c.list().stream().flatMap(a -> a.getUsers().stream()).flatMap(u -> u.getIdentities().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected List<UserIdentity> getOwnedEntities(User owner) {
        return owner.getApplications().stream().flatMap(a -> a.getUsers().stream()).flatMap(u -> u.getIdentities().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/identity/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseFilterByUser() {
        User filtered = this.getAdminContext().getUserIdentity().getUser();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", IdUtil.toString((BigInteger)filtered.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(identity -> identity.getUser().equals((Object)filtered)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)filtered, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByInvalidUser() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.browse(params, this.getAdminToken());
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByMalformedUser() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", "malformed");
        Response r = this.browse(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testBrowseFilterByType() {
        Authenticator authenticator = this.getAdminContext().getAuthenticator();
        AuthenticatorType type = authenticator.getType();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type.toString());
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(identity -> identity.getType().equals((Object)type)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testBrowseFilterByInvalidType() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "malformed");
        Response r = this.browse(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

