/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ScopeServiceSearchTest
extends AbstractServiceSearchTest<ApplicationScope> {
    private static final GenericType<ListResponseEntity<ApplicationScope>> LIST_TYPE = new GenericType<ListResponseEntity<ApplicationScope>>(){};

    public ScopeServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(ApplicationScope.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:scope_admin", false}, {ClientType.Implicit, "kangaroo:scope", false}, {ClientType.Implicit, "kangaroo:scope_admin", true}, {ClientType.Implicit, "kangaroo:scope", true}, {ClientType.ClientCredentials, "kangaroo:scope_admin", false}, {ClientType.ClientCredentials, "kangaroo:scope", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:scope_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:scope";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/scope/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testSearchByApplication() {
        String query = "many";
        OAuthToken token = this.getAdminToken();
        Application a = this.getAdminContext().getApplication();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("application", IdUtil.toString((BigInteger)a.getId()));
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getApplication().equals((Object)a)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.getAttached(token).getScopes().keySet().contains("kangaroo:scope_admin")) {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidApplication() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "application");
        params.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, this.getAdminToken());
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected GenericType<ListResponseEntity<ApplicationScope>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<ApplicationScope> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getScopes().values().stream()).collect(Collectors.toList());
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"name"};
    }
}

