/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ScopeServiceCRUDTest
extends AbstractServiceCRUDTest<ApplicationScope> {
    private static final GenericType<ListResponseEntity<ApplicationScope>> LIST_TYPE = new GenericType<ListResponseEntity<ApplicationScope>>(){};

    public ScopeServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(ApplicationScope.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:scope_admin", false, true}, {ClientType.Implicit, "kangaroo:scope", false, true}, {ClientType.Implicit, "kangaroo:scope_admin", true, true}, {ClientType.Implicit, "kangaroo:scope", true, false}, {ClientType.ClientCredentials, "kangaroo:scope_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:scope", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<ApplicationScope>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:scope_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:scope";
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/scope/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Override
    protected ApplicationScope getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getScope();
    }

    @Override
    protected ApplicationScope getNewEntity() {
        return new ApplicationScope();
    }

    @Override
    protected ApplicationScope createValidEntity(ApplicationBuilder.ApplicationContext context) {
        ApplicationScope s = new ApplicationScope();
        s.setName(RandomStringUtils.randomAlphabetic((int)10));
        s.setApplication(context.getApplication());
        return s;
    }

    @Test
    public void testPostDuplicateScopeName() throws Exception {
        OAuthToken token = this.getAdminToken();
        Application parentApp = token.getClient().getApplication();
        String scopeName = ((ApplicationScope)parentApp.getScopes().values().iterator().next()).getName();
        ApplicationScope newScope = new ApplicationScope();
        newScope.setApplication(parentApp);
        newScope.setName(scopeName);
        Response r = this.postEntity((AbstractAuthzEntity)newScope, token);
        if (this.shouldSucceed().booleanValue()) {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"conflict", (Object)response.getError());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"bad_request", (Object)response.getError());
        }
    }

    @Test
    public void testPostNoParent() throws Exception {
        OAuthToken token = this.getAdminToken();
        ApplicationScope newScope = new ApplicationScope();
        newScope.setName(RandomStringUtils.random((int)20));
        Response r = this.postEntity((AbstractAuthzEntity)newScope, token);
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)"bad_request", (Object)response.getError());
    }

    @Test
    public void testPostOverwrite() throws Exception {
        ApplicationBuilder.ApplicationContext otherApp = this.getSecondaryContext();
        ApplicationScope newScope = new ApplicationScope();
        newScope.setId(otherApp.getScope().getId());
        newScope.setName(RandomStringUtils.random((int)20));
        newScope.setApplication(otherApp.getScope().getApplication());
        Response r = this.postEntity((AbstractAuthzEntity)newScope, this.getAdminToken());
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)"bad_request", (Object)response.getError());
    }

    @Test
    public void testPostTooLongName() throws Exception {
        ApplicationScope newScope = this.createValidEntity(this.getAdminContext());
        newScope.setName(RandomStringUtils.randomAlphanumeric((int)257));
        Response r = this.postEntity((AbstractAuthzEntity)newScope, this.getAdminToken());
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)"bad_request", (Object)response.getError());
    }

    @Test
    public void testPostApplicationAssign() throws Exception {
        OAuthToken token = this.getAdminToken();
        ApplicationBuilder.ApplicationContext yetAnotherApp = ApplicationBuilder.newApplication(this.getSession()).build();
        ApplicationScope newScope = new ApplicationScope();
        newScope.setName(RandomStringUtils.randomAlphanumeric((int)20));
        newScope.setApplication(yetAnotherApp.getApplication());
        Response r = this.postEntity((AbstractAuthzEntity)newScope, token);
        if (this.getTokenScope().equals(this.getAdminScope())) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), token);
            ApplicationScope response = (ApplicationScope)getResponse.readEntity(ApplicationScope.class);
            Assert.assertNotNull((Object)response.getId());
            Assert.assertEquals((Object)newScope.getName(), (Object)response.getName());
            Assert.assertEquals((Object)yetAnotherApp.getApplication(), (Object)response.getApplication());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"bad_request", (Object)response.getError());
        }
    }

    @Test
    public void testPutAdminScope() throws Exception {
        String newName = IdUtil.toString((BigInteger)IdUtil.next());
        ApplicationScope scope = this.getAdminContext().getScope();
        scope.setName(newName);
        Response r = this.putEntity((AbstractAuthzEntity)scope, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)r.getStatus());
            ErrorResponseBuilder.ErrorResponse result = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((Object)"forbidden", (Object)result.getError());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"not_found", (Object)response.getError());
        }
    }

    @Test
    public void testPutRegularScope() throws Exception {
        ApplicationScope scope = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)scope);
        s.getTransaction().commit();
        String newName = IdUtil.toString((BigInteger)IdUtil.next());
        scope.setName(newName);
        Response r = this.putEntity((AbstractAuthzEntity)scope, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)scope, this.getAdminToken())) {
            ApplicationScope response = (ApplicationScope)r.readEntity(ApplicationScope.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)newName, (Object)response.getName());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"not_found", (Object)response.getError());
        }
    }

    @Test
    public void testPutChangeOwner() throws Exception {
        Application app = this.getAdminContext().getApplication();
        ApplicationScope scope = new ApplicationScope();
        scope.setId(this.getSecondaryContext().getScope().getId());
        scope.setName(this.getSecondaryContext().getScope().getName());
        scope.setApplication(app);
        Response r = this.putEntity((AbstractAuthzEntity)scope, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)this.getSecondaryContext().getScope(), this.getAdminToken())) {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"bad_request", (Object)response.getError());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"not_found", (Object)response.getError());
        }
    }

    @Test
    public void testDeleteAdminScope() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Response r = this.deleteEntity((AbstractAuthzEntity)context.getScope(), this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"forbidden", (Object)response.getError());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"not_found", (Object)response.getError());
        }
    }

    @Test
    public void testDeleteRegularScope() throws Exception {
        ApplicationScope scope = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)scope);
        s.getTransaction().commit();
        Response r = this.deleteEntity((AbstractAuthzEntity)scope, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)scope, this.getAdminToken())) {
            Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)r.getStatus());
        } else {
            ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)"not_found", (Object)response.getError());
        }
    }
}

