/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ScopeServiceBrowseTest
extends AbstractServiceBrowseTest<ApplicationScope> {
    private static final GenericType<ListResponseEntity<ApplicationScope>> LIST_TYPE = new GenericType<ListResponseEntity<ApplicationScope>>(){};

    public ScopeServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:scope_admin", false}, {ClientType.Implicit, "kangaroo:scope", false}, {ClientType.Implicit, "kangaroo:scope_admin", true}, {ClientType.Implicit, "kangaroo:scope", true}, {ClientType.ClientCredentials, "kangaroo:scope_admin", false}, {ClientType.ClientCredentials, "kangaroo:scope", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:scope_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:scope";
    }

    @Override
    protected GenericType<ListResponseEntity<ApplicationScope>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<ApplicationScope> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria c = this.getSession().createCriteria(Application.class);
        return c.list().stream().flatMap(a -> a.getScopes().values().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected List<ApplicationScope> getOwnedEntities(User owner) {
        return owner.getApplications().stream().flatMap(a -> a.getScopes().values().stream()).collect(Collectors.toList());
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/scope/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseByApplication() {
        OAuthToken token = this.getAdminToken();
        Application adminApp = this.getAdminContext().getApplication();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("application", IdUtil.toString((BigInteger)adminApp.getId()));
        Response r = this.browse(params, token);
        List expectedResults = this.getAccessibleEntities(token).stream().filter(scope -> adminApp.equals((Object)scope.getApplication())).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)adminApp, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseByRole() {
        OAuthToken token = this.getAdminToken();
        Role role = (Role)this.getAdminContext().getApplication().getRoles().stream().filter(r -> r.getName().equals("admin")).collect(Collectors.toList()).get(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("role", IdUtil.toString((BigInteger)role.getId()));
        Response r2 = this.browse(params, token);
        List expectedResults = this.getAccessibleEntities(token).stream().filter(scope -> scope.getRoles().contains(role)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r2, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)role, this.getAdminToken())) {
            this.assertListResponse(r2, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r2, Response.Status.BAD_REQUEST);
        }
    }
}

