/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class RoleServiceSearchTest
extends AbstractServiceSearchTest<Role> {
    private static final GenericType<ListResponseEntity<Role>> LIST_TYPE = new GenericType<ListResponseEntity<Role>>(){};

    public RoleServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(Role.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:role_admin", false}, {ClientType.Implicit, "kangaroo:role", false}, {ClientType.Implicit, "kangaroo:role_admin", true}, {ClientType.Implicit, "kangaroo:role", true}, {ClientType.ClientCredentials, "kangaroo:role_admin", false}, {ClientType.ClientCredentials, "kangaroo:role", false});
    }

    @Override
    protected GenericType<ListResponseEntity<Role>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<Role> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getRoles().stream()).collect(Collectors.toList());
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"name"};
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:role_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:role";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/role/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testSearchByApplication() {
        String query = "many";
        Application a = this.getSecondaryContext().getApplication();
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("application", IdUtil.toString((BigInteger)a.getId()));
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getApplication().equals((Object)a)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)a, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            Assert.assertTrue((expectedTotal > 1 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidApplication() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedApplication() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("application", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }
}

