/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.admin.v1.resource.RoleScopeService;
import net.krotscheck.kangaroo.authz.admin.v1.resource.RoleService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class RoleServiceCRUDTest
extends AbstractServiceCRUDTest<Role> {
    private static final GenericType<ListResponseEntity<Role>> LIST_TYPE = new GenericType<ListResponseEntity<Role>>(){};

    public RoleServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Role.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:role_admin", false, true}, {ClientType.Implicit, "kangaroo:role", false, true}, {ClientType.Implicit, "kangaroo:role_admin", true, true}, {ClientType.Implicit, "kangaroo:role", true, false}, {ClientType.ClientCredentials, "kangaroo:role_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:role", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<Role>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/role/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    private String getUrlForSubresourceId(BigInteger id, BigInteger subId) {
        return this.getUrlForSubresourceId(IdUtil.toString((BigInteger)id), IdUtil.toString((BigInteger)subId));
    }

    private String getUrlForSubresourceId(String id, String subId) {
        URI firstPath = this.getUrlForId(id);
        if (subId == null) {
            return String.format("%s/scope/", firstPath);
        }
        return String.format("%s/scope/%s", firstPath, subId);
    }

    @Override
    protected Role getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getRole();
    }

    @Override
    protected Role getNewEntity() {
        return new Role();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:role_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:role";
    }

    @Override
    protected Role createValidEntity(ApplicationBuilder.ApplicationContext context) {
        Role role = new Role();
        role.setApplication(context.getApplication());
        role.setName(RandomStringUtils.randomAlphanumeric((int)10));
        return role;
    }

    @Test
    public void testPostNoParent() throws Exception {
        Role testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setApplication(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostTooLongName() throws Exception {
        Role testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setName(RandomStringUtils.randomAlphanumeric((int)257));
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostTooShortName() throws Exception {
        Role testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setName(RandomStringUtils.randomAlphanumeric((int)2));
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoName() throws Exception {
        Role testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setName(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPutRole() throws Exception {
        Role testEntity = this.getEntity(this.getSecondaryContext());
        String newName = IdUtil.toString((BigInteger)IdUtil.next());
        testEntity.setName(newName);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Role result = (Role)r.readEntity(Role.class);
            Assert.assertEquals((Object)testEntity.getId(), (Object)result.getId());
            Assert.assertEquals((Object)newName, (Object)testEntity.getName());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeApplication() throws Exception {
        Application otherApplication = this.getAdminContext().getApplication();
        Role entity = this.getEntity(this.getSecondaryContext());
        Role testEntity = (Role)entity.clone();
        testEntity.setApplication(otherApplication);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)entity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutAdminApp() throws Exception {
        Role testEntity = (Role)this.getEntity(this.getAdminContext()).clone();
        testEntity.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testDeleteAdminRole() throws Exception {
        Role testEntity = this.getEntity(this.getAdminContext());
        Response r = this.deleteEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testDeleteDefaultRole() throws Exception {
        Application second = this.getSecondaryContext().getApplication();
        Role defaultRole = second.getDefaultRole();
        Assert.assertNotNull((Object)defaultRole);
        Response r = this.deleteEntity((AbstractAuthzEntity)defaultRole, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)defaultRole, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddScope() throws Exception {
        Session s = this.getSession();
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext testContext = this.getSecondaryContext().getBuilder().scope(IdUtil.toString((BigInteger)IdUtil.next())).build();
        Role role = this.getEntity(testContext);
        String url = this.getUrlForSubresourceId(role.getId(), testContext.getScope().getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.isAccessible((AbstractAuthzEntity)testContext.getScope(), token)) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            s.refresh((Object)role);
            Assert.assertTrue((boolean)role.getScopes().values().contains(testContext.getScope()));
            s.getTransaction().begin();
            role.getScopes().remove(testContext.getScope().getName());
            s.update((Object)role);
            s.getTransaction().commit();
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddAlreadyLinkedScope() throws Exception {
        ApplicationBuilder.ApplicationContext secondaryContext = this.getSecondaryContext();
        Role editedRole = this.getAttached(secondaryContext.getRole());
        Application app = this.getAttached(secondaryContext.getApplication());
        ApplicationScope newScope = new ApplicationScope();
        newScope.setApplication(app);
        newScope.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        editedRole.getScopes().put(newScope.getName(), newScope);
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)newScope);
        s.update((Object)editedRole);
        s.getTransaction().commit();
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        String url = this.getUrlForSubresourceId(editedRole.getId(), newScope.getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.isAccessible((AbstractAuthzEntity)newScope, token)) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
        s.getTransaction().begin();
        s.delete((Object)newScope);
        s.getTransaction().commit();
    }

    @Test
    public void testAddInvalidAppScope() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = this.getEntity(context);
        String url = this.getUrlForSubresourceId(role.getId(), IdUtil.next());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddMalformedScope() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = this.getEntity(context);
        String url = this.getUrlForSubresourceId(IdUtil.toString((BigInteger)role.getId()), "malformed");
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddScopeApplicationMismatch() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").scope(IdUtil.toString((BigInteger)IdUtil.next())).build();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = this.getEntity(context);
        String url = this.getUrlForSubresourceId(role.getId(), testContext.getScope().getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)testContext.getToken().getId())).post(null);
        if (this.isAccessible((AbstractAuthzEntity)role, testContext.getToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddScopeNoSubresourcePermission() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope()).build().getToken();
        ApplicationBuilder.ApplicationContext testContext = this.getSecondaryContext().getBuilder().scope(IdUtil.toString((BigInteger)IdUtil.next())).build();
        Role role = this.getEntity(testContext);
        String url = this.getUrlForSubresourceId(role.getId(), testContext.getScope().getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.isAccessible((AbstractAuthzEntity)testContext.getScope(), token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST, "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddScopeRegularSubresourcePermission() throws Exception {
        Session s = this.getSession();
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = this.getEntity(context);
        ApplicationScope scope = context.getBuilder().scope(IdUtil.toString((BigInteger)IdUtil.next())).build().getScope();
        String url = this.getUrlForSubresourceId(role.getId(), scope.getId());
        Boolean shouldSucceed = this.shouldSucceed() != false && this.isAccessible((AbstractAuthzEntity)scope, token, "kangaroo:scope_admin");
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (shouldSucceed.booleanValue()) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            s.refresh((Object)role);
            Assert.assertTrue((boolean)role.getScopes().values().contains(scope));
            s.getTransaction().begin();
            role.getScopes().remove(scope.getName());
            s.update((Object)role);
            s.getTransaction().commit();
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testAddAdminApplication() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Role role = this.getEntity(context);
        ApplicationScope scope = context.getBuilder().scope(IdUtil.toString((BigInteger)IdUtil.next())).build().getScope();
        String url = this.getUrlForSubresourceId(role.getId(), scope.getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).post(null);
        if (this.isAccessible((AbstractAuthzEntity)scope, token)) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testRemoveScope() throws Exception {
        ApplicationBuilder.ApplicationContext secondaryContext = this.getSecondaryContext();
        Role editedRole = this.getAttached(secondaryContext.getRole());
        Application app = this.getAttached(secondaryContext.getApplication());
        ApplicationScope newScope = new ApplicationScope();
        newScope.setApplication(app);
        newScope.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        editedRole.getScopes().put(newScope.getName(), newScope);
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)newScope);
        s.update((Object)editedRole);
        s.getTransaction().commit();
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        String url = this.getUrlForSubresourceId(editedRole.getId(), newScope.getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.isAccessible((AbstractAuthzEntity)newScope, token)) {
            Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)r.getStatus());
            this.getSession().refresh((Object)editedRole);
            Assert.assertFalse((boolean)editedRole.getScopes().values().contains(newScope));
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
        s.getTransaction().begin();
        s.delete((Object)newScope);
        s.getTransaction().commit();
    }

    @Test
    public void testRemoveInvalidScope() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = context.getRole();
        String url = this.getUrlForSubresourceId(role.getId(), IdUtil.next());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testRemoveUnlinkedScope() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext().getBuilder().scope(IdUtil.toString((BigInteger)IdUtil.next())).build();
        Role role = this.getAttached(context.getRole());
        ApplicationScope scope = this.getAttached(context.getScope());
        Assert.assertFalse((boolean)role.getScopes().values().contains(scope));
        String url = this.getUrlForSubresourceId(role.getId(), scope.getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testRemoveMalformedScope() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = context.getRole();
        String url = this.getUrlForSubresourceId(IdUtil.toString((BigInteger)role.getId()), "malformed");
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testRemoveScopeNoSubresourcePermission() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope()).build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        Role role = (Role)context.getApplication().getRoles().stream().filter(r -> r.getScopes().size() > 0).collect(Collectors.toList()).get(0);
        ApplicationScope scope = (ApplicationScope)role.getScopes().values().iterator().next();
        Assert.assertTrue((boolean)role.getScopes().values().contains(scope));
        String url = this.getUrlForSubresourceId(role.getId(), scope.getId());
        Response r2 = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.isAccessible((AbstractAuthzEntity)scope, token)) {
            this.assertErrorResponse(r2, Response.Status.BAD_REQUEST, "invalid_scope");
        } else {
            this.assertErrorResponse(r2, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testRemoveScopeRegularSubresourcePermission() throws Exception {
        ApplicationBuilder.ApplicationContext secondaryContext = this.getSecondaryContext();
        Role editedRole = this.getAttached(secondaryContext.getRole());
        Application app = this.getAttached(secondaryContext.getApplication());
        ApplicationScope newScope = new ApplicationScope();
        newScope.setApplication(app);
        newScope.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        editedRole.getScopes().put(newScope.getName(), newScope);
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)newScope);
        s.update((Object)editedRole);
        s.getTransaction().commit();
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getSecondaryContext();
        String url = this.getUrlForSubresourceId(editedRole.getId(), newScope.getId());
        Boolean shouldSucceed = this.shouldSucceed() != false && this.isAccessible((AbstractAuthzEntity)newScope, token, "kangaroo:scope_admin");
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (shouldSucceed.booleanValue()) {
            Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)r.getStatus());
            this.getSession().refresh((Object)editedRole);
            Assert.assertFalse((boolean)editedRole.getScopes().values().contains(newScope));
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
        s.getTransaction().begin();
        s.delete((Object)newScope);
        s.getTransaction().commit();
    }

    @Test
    public void testRemoveScopeAdminApplication() throws Exception {
        OAuthToken token = this.getAdminContext().getBuilder().bearerToken(this.getAdminClient(), this.getTokenScope(), "kangaroo:scope_admin").build().getToken();
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Role role = context.getRole();
        ApplicationScope scope = (ApplicationScope)role.getScopes().values().iterator().next();
        Assert.assertTrue((boolean)role.getScopes().values().contains(scope));
        String url = this.getUrlForSubresourceId(role.getId(), scope.getId());
        Response r = this.target(url).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).delete();
        if (this.isAccessible((AbstractAuthzEntity)scope, token)) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testGetScopes() {
        RoleService roleService = new RoleService();
        Assert.assertEquals((Object)"kangaroo:role", (Object)roleService.getAccessScope());
        Assert.assertEquals((Object)"kangaroo:role_admin", (Object)roleService.getAdminScope());
        RoleScopeService roleScopeService = new RoleScopeService();
        Assert.assertEquals((Object)"kangaroo:role", (Object)roleScopeService.getAccessScope());
        Assert.assertEquals((Object)"kangaroo:role_admin", (Object)roleScopeService.getAdminScope());
    }
}

