/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class OAuthTokenServiceSearchTest
extends AbstractServiceSearchTest<OAuthToken> {
    private static final GenericType<ListResponseEntity<OAuthToken>> LIST_TYPE = new GenericType<ListResponseEntity<OAuthToken>>(){};

    public OAuthTokenServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(OAuthToken.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:token_admin", false}, {ClientType.Implicit, "kangaroo:token", false}, {ClientType.Implicit, "kangaroo:token_admin", true}, {ClientType.Implicit, "kangaroo:token", true}, {ClientType.ClientCredentials, "kangaroo:token_admin", false}, {ClientType.ClientCredentials, "kangaroo:token", false});
    }

    @Override
    protected GenericType<ListResponseEntity<OAuthToken>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<OAuthToken> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getClients().stream()).flatMap(c -> c.getTokens().stream()).collect(Collectors.toList());
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"identity.remoteId", "identity.claims"};
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:token_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:token";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/token/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testSearchByUser() {
        Application app = this.getSecondaryContext().getApplication();
        String query = "many";
        List searchResults = this.getSearchResults(query);
        User user = (User)searchResults.stream().filter(t -> t.getClient().getApplication().equals((Object)app)).map(OAuthToken::getIdentity).map(UserIdentity::getUser).collect(Collectors.toList()).get(0);
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("user", IdUtil.toString((BigInteger)user.getId()));
        Response r = this.search(params, token);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getIdentity() != null).filter(item -> item.getIdentity().getUser().equals((Object)user)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)user, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidUser() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("user", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedUser() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("user", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSearchByIdentity() {
        Application app = this.getSecondaryContext().getApplication();
        String query = "many";
        List searchResults = this.getSearchResults(query);
        UserIdentity identity = (UserIdentity)searchResults.stream().filter(t -> t.getClient().getApplication().equals((Object)app)).map(OAuthToken::getIdentity).collect(Collectors.toList()).get(0);
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("identity", IdUtil.toString((BigInteger)identity.getId()));
        Response r = this.search(params, token);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getIdentity().equals((Object)identity)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)identity, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidIdentity() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("identity", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedIdentity() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("identity", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSearchByClient() {
        String query = "many";
        Client client = this.getSecondaryContext().getClient();
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("client", IdUtil.toString((BigInteger)client.getId()));
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getClient().equals((Object)client)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)client, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidClient() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("client", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedClient() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("client", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSearchByType() {
        String query = "many";
        OAuthTokenType type = OAuthTokenType.Bearer;
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("type", type.toString());
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getTokenType().equals((Object)type)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidType() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("type", "Invalid Type");
        Response r = this.search(params, token);
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

