/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class OAuthTokenServiceCRUDTest
extends AbstractServiceCRUDTest<OAuthToken> {
    private static final GenericType<ListResponseEntity<OAuthToken>> LIST_TYPE = new GenericType<ListResponseEntity<OAuthToken>>(){};

    public OAuthTokenServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(OAuthToken.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:token_admin", false, true}, {ClientType.Implicit, "kangaroo:token", false, true}, {ClientType.Implicit, "kangaroo:token_admin", true, true}, {ClientType.Implicit, "kangaroo:token", true, false}, {ClientType.OwnerCredentials, "kangaroo:token_admin", false, true}, {ClientType.OwnerCredentials, "kangaroo:token", false, true}, {ClientType.OwnerCredentials, "kangaroo:token_admin", true, true}, {ClientType.OwnerCredentials, "kangaroo:token", true, false}, {ClientType.AuthorizationGrant, "kangaroo:token_admin", false, true}, {ClientType.AuthorizationGrant, "kangaroo:token", false, true}, {ClientType.AuthorizationGrant, "kangaroo:token_admin", true, true}, {ClientType.AuthorizationGrant, "kangaroo:token", true, false}, {ClientType.ClientCredentials, "kangaroo:token_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:token", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<OAuthToken>> getListType() {
        return LIST_TYPE;
    }

    private OAuthToken createValidToken(ApplicationBuilder.ApplicationContext context, OAuthTokenType type) {
        OAuthToken token = null;
        switch (type) {
            case Authorization: {
                token = this.createAuthorizationToken(context);
                break;
            }
            case Refresh: {
                token = this.createRefreshToken(context);
                break;
            }
            default: {
                token = this.createBearerToken(context);
            }
        }
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)token);
        s.getTransaction().commit();
        return token;
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/token/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Override
    protected OAuthToken getEntity(ApplicationBuilder.ApplicationContext context) {
        return this.getAttached(context.getToken());
    }

    @Override
    protected OAuthToken getNewEntity() {
        return new OAuthToken();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:token_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:token";
    }

    @Override
    protected OAuthToken createValidEntity(ApplicationBuilder.ApplicationContext context) {
        switch (this.getClientType()) {
            case AuthorizationGrant: {
                return this.createAuthorizationToken(context);
            }
            case Implicit: {
                return this.createBearerToken(context);
            }
        }
        return this.createBearerToken(context);
    }

    private OAuthToken createAuthorizationToken(ApplicationBuilder.ApplicationContext context) {
        Application a = this.getAttached(context.getApplication());
        List clients = a.getClients().stream().filter(c -> c.getType().equals((Object)this.getClientType())).collect(Collectors.toList());
        List authTypes = clients.stream().flatMap(c -> c.getAuthenticators().stream()).map(Authenticator::getType).distinct().collect(Collectors.toList());
        List identityClients = clients.stream().flatMap(c -> c.getAuthenticators().stream()).filter(atx -> authTypes.contains(atx.getType())).map(Authenticator::getClient).distinct().collect(Collectors.toList());
        Client client = identityClients.size() > 0 ? (Client)identityClients.get(0) : (Client)clients.get(0);
        List cAuthTypes = client.getAuthenticators().stream().map(Authenticator::getType).distinct().collect(Collectors.toList());
        List identities = a.getUsers().stream().flatMap(u -> u.getIdentities().stream()).filter(id -> cAuthTypes.contains(id.getType())).distinct().collect(Collectors.toList());
        URI redirect = UriBuilder.fromPath((String)"http://invalid.example.com/").build(new Object[0]);
        if (client.getRedirects().size() > 0) {
            redirect = ((ClientRedirect)client.getRedirects().iterator().next()).getUri();
        }
        OAuthToken t = new OAuthToken();
        t.setClient(client);
        t.setTokenType(OAuthTokenType.Authorization);
        t.setRedirect(redirect);
        t.setExpiresIn((Number)client.getAuthorizationCodeExpiresIn());
        t.setIssuer("localhost");
        if (identities.size() > 0) {
            t.setIdentity((UserIdentity)identities.get(0));
        }
        return t;
    }

    private OAuthToken createRefreshToken(ApplicationBuilder.ApplicationContext context) {
        OAuthToken bearerToken = this.createBearerToken(context);
        OAuthToken token = new OAuthToken();
        token.setClient(bearerToken.getClient());
        token.setTokenType(OAuthTokenType.Refresh);
        token.setExpiresIn((Number)bearerToken.getClient().getRefreshTokenExpireIn());
        token.setScopes(context.getScopes());
        token.setIdentity(bearerToken.getIdentity());
        token.setIssuer("localhost");
        return token;
    }

    private OAuthToken createBearerToken(ApplicationBuilder.ApplicationContext context) {
        Application a = this.getAttached(context.getApplication());
        List clients = a.getClients().stream().filter(c -> c.getType().equals((Object)this.getClientType())).filter(c -> c.getAuthenticators().size() > 0).collect(Collectors.toList());
        Client client = (Client)clients.get(0);
        List types = client.getAuthenticators().stream().map(Authenticator::getType).distinct().collect(Collectors.toList());
        List identities = a.getUsers().stream().flatMap(u -> u.getIdentities().stream()).distinct().filter(uid -> types.contains(uid.getType())).collect(Collectors.toList());
        OAuthToken token = new OAuthToken();
        token.setClient(client);
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn((Number)client.getAccessTokenExpireIn());
        token.setScopes(context.getScopes());
        token.setIssuer("localhost");
        if (identities.size() > 0 && !client.getType().equals((Object)ClientType.ClientCredentials)) {
            token.setIdentity((UserIdentity)identities.get(0));
        }
        return token;
    }

    @Test
    public void testPostTooSmallExpiresIn() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setExpiresIn(0);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoExpiresIn() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setExpiresIn(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoTokenType() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostIdentity() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        if (testEntity.getIdentity() == null) {
            testEntity.setIdentity(this.getAdminContext().getUserIdentity());
        }
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue() && !this.getClientType().equals((Object)ClientType.ClientCredentials)) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            OAuthToken response = (OAuthToken)getResponse.readEntity(OAuthToken.class);
            this.assertContentEquals((AbstractAuthzEntity)testEntity, (AbstractAuthzEntity)response);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostIdentityFromWrongApp() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        UserIdentity otherIdentity = this.getSecondaryContext().getBuilder().identity().build().getUserIdentity();
        testEntity.setIdentity(otherIdentity);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostRefreshWithIdentity() throws Exception {
        OAuthToken bearerToken = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setAuthToken(bearerToken);
        testEntity.setRedirect(null);
        if (testEntity.getIdentity() == null) {
            testEntity.setIdentity(this.getAdminContext().getUserIdentity());
        }
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue() && !this.getClientType().equals((Object)ClientType.Implicit) && !this.getClientType().equals((Object)ClientType.ClientCredentials)) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            OAuthToken response = (OAuthToken)getResponse.readEntity(OAuthToken.class);
            this.assertContentEquals((AbstractAuthzEntity)testEntity, (AbstractAuthzEntity)response);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostRefreshWithoutIdentity() throws Exception {
        OAuthToken bearerToken = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setAuthToken(bearerToken);
        testEntity.setRedirect(null);
        testEntity.setIdentity(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostRefreshNoBearerToken() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setRedirect(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostRefreshWithAuthToken() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        OAuthToken authToken = this.createValidToken(context, OAuthTokenType.Authorization);
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setAuthToken(authToken);
        testEntity.setRedirect(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostRefreshWrongBearerTokenParent() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().identity().build();
        OAuthToken bearerToken = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setAuthToken(bearerToken);
        testEntity.setIdentity(testContext.getUserIdentity());
        testEntity.setRedirect(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostRefreshWithRedirect() throws Exception {
        OAuthToken bearerToken = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Refresh);
        testEntity.setAuthToken(bearerToken);
        if (testEntity.getRedirect() == null) {
            testEntity.setRedirect(UriBuilder.fromPath((String)"http://redirect.example.com/redirect").build(new Object[0]));
        }
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostBearerWithRedirect() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Bearer);
        if (testEntity.getRedirect() == null) {
            testEntity.setRedirect(UriBuilder.fromPath((String)"http://redirect.example.com/redirect").build(new Object[0]));
        }
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostBearerWithParentToken() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setTokenType(OAuthTokenType.Bearer);
        testEntity.setAuthToken(this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer));
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostAuthInvalidRedirect() throws Exception {
        OAuthToken testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setRedirect(UriBuilder.fromPath((String)"http://invalid.example.com").build(new Object[0]));
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostAuthNoRedirect() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().redirect().redirect().build();
        OAuthToken testEntity = this.createValidEntity(testContext);
        testEntity.setTokenType(OAuthTokenType.Authorization);
        testEntity.setRedirect(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPutTooSmallExpiresIn() throws Exception {
        OAuthToken token = (OAuthToken)this.getAdminToken().clone();
        token.setExpiresIn(0);
        Response r = this.putEntity((AbstractAuthzEntity)token, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutNoExpiresIn() throws Exception {
        OAuthToken token = (OAuthToken)this.getAdminToken().clone();
        token.setExpiresIn(null);
        Response r = this.putEntity((AbstractAuthzEntity)token, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutNoTokenType() throws Exception {
        OAuthToken token = (OAuthToken)this.getAdminToken().clone();
        token.setTokenType(null);
        Response r = this.putEntity((AbstractAuthzEntity)token, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPut() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        testEntity.setExpiresIn(testEntity.getExpiresIn() + 100L);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            OAuthToken response = (OAuthToken)r.readEntity(OAuthToken.class);
            this.assertContentEquals((AbstractAuthzEntity)testEntity, (AbstractAuthzEntity)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutIdentity() throws Exception {
        UserIdentity newIdentity = this.getAdminContext().getBuilder().identity().build().getUserIdentity();
        OAuthToken testEntity = this.getAdminToken();
        testEntity.setIdentity(newIdentity);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutIdentityFromWrongApp() throws Exception {
        OAuthToken testEntity = this.getAdminToken();
        UserIdentity otherIdentity = this.getSecondaryContext().getBuilder().identity().build().getUserIdentity();
        testEntity.setIdentity(otherIdentity);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithIdentity() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        UserIdentity identity = this.getAdminContext().getBuilder().identity().build().getUserIdentity();
        testEntity.setIdentity(identity);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithoutIdentity() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        testEntity.setIdentity(null);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithClient() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        Client client = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).build().getClient();
        testEntity.setClient(client);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithoutClient() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        testEntity.setClient(null);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshNoBearerToken() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        testEntity.setAuthToken(null);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithAuthToken() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        OAuthToken authToken = this.createValidToken(this.getAdminContext(), OAuthTokenType.Authorization);
        testEntity.setAuthToken(authToken);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWrongBearerTokenParent() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().identity().build();
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        testEntity.setIdentity(testContext.getUserIdentity());
        testEntity.setRedirect(null);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRefreshWithRedirect() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Refresh);
        if (testEntity.getRedirect() == null) {
            testEntity.setRedirect(UriBuilder.fromPath((String)"http://redirect.example.com/redirect").build(new Object[0]));
        }
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutBearerWithRedirect() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Bearer);
        if (testEntity.getRedirect() == null) {
            testEntity.setRedirect(UriBuilder.fromPath((String)"http://redirect.example.com/redirect").build(new Object[0]));
        }
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutAuthInvalidRedirect() throws Exception {
        OAuthToken testEntity = this.createValidToken(this.getAdminContext(), OAuthTokenType.Authorization);
        testEntity.setRedirect(UriBuilder.fromPath((String)"http://invalid.example.com/").build(new Object[0]));
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutAuthNoRedirect() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().redirect().redirect().build();
        OAuthToken testEntity = this.createValidToken(testContext, OAuthTokenType.Authorization);
        testEntity.setRedirect(null);
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

