/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class OAuthTokenServiceBrowseTest
extends AbstractServiceBrowseTest<OAuthToken> {
    private static final GenericType<ListResponseEntity<OAuthToken>> LIST_TYPE = new GenericType<ListResponseEntity<OAuthToken>>(){};

    public OAuthTokenServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:token_admin", false}, {ClientType.Implicit, "kangaroo:token", false}, {ClientType.Implicit, "kangaroo:token_admin", true}, {ClientType.Implicit, "kangaroo:token", true}, {ClientType.ClientCredentials, "kangaroo:token_admin", false}, {ClientType.ClientCredentials, "kangaroo:token", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:token_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:token";
    }

    @Override
    protected GenericType<ListResponseEntity<OAuthToken>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<OAuthToken> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria criteria = this.getSession().createCriteria(OAuthToken.class);
        return criteria.list();
    }

    @Override
    protected List<OAuthToken> getOwnedEntities(User owner) {
        return owner.getApplications().stream().flatMap(a -> a.getClients().stream()).flatMap(c -> c.getTokens().stream()).collect(Collectors.toList());
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/token/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseFilterByClient() {
        Client c = this.getAdminContext().getClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client", IdUtil.toString((BigInteger)c.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(token -> token.getClient().equals((Object)c)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)c, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testBrowseFilterByIdentity() {
        UserIdentity identity = this.getAdminContext().getUserIdentity();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("identity", IdUtil.toString((BigInteger)identity.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(token -> token.getIdentity() != null).filter(token -> token.getIdentity().equals((Object)identity)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)identity, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }
}

