/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class ClientServiceCRUDTest
extends AbstractServiceCRUDTest<Client> {
    private static final GenericType<ListResponseEntity<Client>> LIST_TYPE = new GenericType<ListResponseEntity<Client>>(){};

    public ClientServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Client.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:client_admin", false, true}, {ClientType.Implicit, "kangaroo:client", false, true}, {ClientType.Implicit, "kangaroo:client_admin", true, true}, {ClientType.Implicit, "kangaroo:client", true, false}, {ClientType.ClientCredentials, "kangaroo:client_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:client", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<Client>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/client/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Override
    protected Client getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getClient();
    }

    @Override
    protected Client getNewEntity() {
        return new Client();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:client";
    }

    @Override
    protected Client createValidEntity(ApplicationBuilder.ApplicationContext context) {
        Client c = new Client();
        c.setApplication(context.getApplication());
        c.setName(RandomStringUtils.randomAlphanumeric((int)10));
        c.setClientSecret(RandomStringUtils.randomAlphanumeric((int)10));
        c.setType(ClientType.ClientCredentials);
        c.getConfiguration().put("foo", "bar");
        c.getConfiguration().put("lol", "cat");
        return c;
    }

    @Test
    public void testPostNoParent() throws Exception {
        Client testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setApplication(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostTooLongName() throws Exception {
        Client testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setName(RandomStringUtils.randomAlphanumeric((int)257));
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoType() throws Exception {
        Client testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setType(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoSecret() throws Exception {
        Client testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setClientSecret(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            Client response = (Client)getResponse.readEntity(Client.class);
            this.assertContentEquals((AbstractAuthzEntity)testEntity, (AbstractAuthzEntity)response);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPutCannotModifyCurrentClient() throws Exception {
        Client client = this.getAdminToken().getClient();
        Client newClient = new Client();
        newClient.setId(client.getId());
        newClient.setName("New Name");
        newClient.setApplication(client.getApplication());
        newClient.setClientSecret(client.getClientSecret());
        newClient.setType(client.getType());
        Response r = this.putEntity((AbstractAuthzEntity)newClient, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRegularEntity() throws Exception {
        Client a = this.getEntity(this.getSecondaryContext());
        a.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        a.setType(ClientType.OwnerCredentials);
        a.setClientSecret(IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.putEntity((AbstractAuthzEntity)a, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            Client response = (Client)r.readEntity(Client.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)a, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeParentEntity() throws Exception {
        Application newParent = this.getAdminContext().getApplication();
        Client entity = this.getEntity(this.getSecondaryContext());
        Client client = new Client();
        client.setId(entity.getId());
        client.setName(entity.getName());
        client.setType(entity.getType());
        client.setApplication(newParent);
        Response r = this.putEntity((AbstractAuthzEntity)client, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)entity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testCannotDeleteCurrentClient() throws Exception {
        Client client = this.getAdminToken().getClient();
        Response r = this.deleteEntity((AbstractAuthzEntity)client, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

