/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ClientServiceBrowseTest
extends AbstractServiceBrowseTest<Client> {
    private static final GenericType<ListResponseEntity<Client>> LIST_TYPE = new GenericType<ListResponseEntity<Client>>(){};

    public ClientServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:client_admin", false}, {ClientType.Implicit, "kangaroo:client", false}, {ClientType.Implicit, "kangaroo:client_admin", true}, {ClientType.Implicit, "kangaroo:client", true}, {ClientType.ClientCredentials, "kangaroo:client_admin", false}, {ClientType.ClientCredentials, "kangaroo:client", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:client";
    }

    @Override
    protected GenericType<ListResponseEntity<Client>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<Client> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria c = this.getSession().createCriteria(Application.class);
        return c.list().stream().flatMap(a -> a.getClients().stream()).collect(Collectors.toList());
    }

    @Override
    protected List<Client> getOwnedEntities(User owner) {
        return owner.getApplications().stream().flatMap(a -> a.getClients().stream()).collect(Collectors.toList());
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/client/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseFilterByApplication() {
        Application filtered = this.getAdminContext().getApplication();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("application", IdUtil.toString((BigInteger)filtered.getId()));
        Response r = this.browse(params, this.getAdminToken());
        Long expectedEntities = this.getAccessibleEntities(this.getAdminToken()).stream().filter(e -> e.getApplication().equals((Object)filtered)).count();
        int expectedTotal = expectedEntities.intValue();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)filtered, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testBrowseFilterByClientType() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", ClientType.AuthorizationGrant.toString());
        Response r = this.browse(params, this.getAdminToken());
        Long expectedEntities = this.getAccessibleEntities(this.getAdminToken()).stream().filter(e -> e.getType().equals((Object)ClientType.AuthorizationGrant)).count();
        int expectedTotal = expectedEntities.intValue();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedEntities > 0L ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }
}

