/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractSubserviceCRUDTest;
import net.krotscheck.kangaroo.authz.admin.v1.resource.ClientReferrerService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class ClientReferrerServiceCRUDTest
extends AbstractSubserviceCRUDTest<Client, ClientReferrer> {
    private static final GenericType<ListResponseEntity<ClientReferrer>> LIST_TYPE = new GenericType<ListResponseEntity<ClientReferrer>>(){};

    public ClientReferrerServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Client.class, ClientReferrer.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:client_admin", false, true}, {ClientType.Implicit, "kangaroo:client", false, true}, {ClientType.Implicit, "kangaroo:client_admin", true, true}, {ClientType.Implicit, "kangaroo:client", true, false}, {ClientType.ClientCredentials, "kangaroo:client_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:client", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<ClientReferrer>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI getUrlForId(String id) {
        String parentId = "";
        Session s = this.getSession();
        s.getTransaction().begin();
        try {
            ClientReferrer r = (ClientReferrer)s.get(ClientReferrer.class, (Serializable)IdUtil.fromString((String)id));
            parentId = IdUtil.toString((BigInteger)r.getClient().getId());
        }
        catch (Exception e) {
            parentId = IdUtil.toString((BigInteger)this.getParentEntity(this.getAdminContext()).getId());
        }
        finally {
            s.getTransaction().commit();
        }
        return this.getUrlForEntity(parentId, id);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        String parentId = "";
        String childId = "";
        ClientReferrer referrer = (ClientReferrer)entity;
        if (referrer == null) {
            return this.getUrlForId(null);
        }
        BigInteger referrerId = referrer.getId();
        childId = referrerId == null ? null : IdUtil.toString((BigInteger)referrerId);
        Client client = referrer.getClient();
        if (client == null) {
            return this.getUrlForId(null);
        }
        BigInteger clientId = client.getId();
        parentId = clientId == null ? null : IdUtil.toString((BigInteger)clientId);
        return this.getUrlForEntity(parentId, childId);
    }

    private URI getUrlForEntity(String parentId, String childId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/client").path(parentId).path("referrer");
        if (childId != null) {
            builder.path(childId);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected Client getParentEntity(ApplicationBuilder.ApplicationContext context) {
        return this.getAttached(context.getClient());
    }

    @Override
    protected ClientReferrer createValidEntity(ApplicationBuilder.ApplicationContext context, Client parent) {
        ClientReferrer r = new ClientReferrer();
        r.setClient(parent);
        r.setUri(URI.create(String.format("http://%s.example.com", IdUtil.next())));
        return r;
    }

    @Override
    protected Client createParentEntity(ApplicationBuilder.ApplicationContext context) {
        Client c = new Client();
        c.setApplication(this.getAttached(context.getApplication()));
        c.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        c.setType(ClientType.AuthorizationGrant);
        return c;
    }

    @Override
    protected ClientReferrer getEntity(ApplicationBuilder.ApplicationContext context) {
        return this.getAttached(context.getReferrer());
    }

    @Override
    protected ClientReferrer getNewEntity() {
        ClientReferrer newEntity = new ClientReferrer();
        newEntity.setClient(this.getAttached(this.getAdminContext().getClient()));
        return newEntity;
    }

    @Test
    public void testPostNoUri() throws Exception {
        ClientReferrer testEntity = (ClientReferrer)this.createValidEntity(this.getSecondaryContext());
        testEntity.setUri(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostDuplicate() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext();
        Client c = this.getAttached(this.getParentEntity(testContext));
        URI existing = ((ClientReferrer)c.getReferrers().get(0)).getUri();
        ClientReferrer testEntity = new ClientReferrer();
        testEntity.setClient(c);
        testEntity.setUri(existing);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPut() throws Exception {
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext();
        ClientReferrer oldEntity = builder.getReferrer();
        ClientReferrer cr = new ClientReferrer();
        cr.setClient(oldEntity.getClient());
        cr.setId(oldEntity.getId());
        cr.setUri(URI.create("http://new.example.com/referrer"));
        Response r = this.putEntity((AbstractAuthzEntity)cr, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            ClientReferrer response = (ClientReferrer)r.readEntity(ClientReferrer.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)cr, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutNoUri() throws Exception {
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext();
        ClientReferrer oldEntity = builder.getReferrer();
        ClientReferrer duplicateReferrer = new ClientReferrer();
        duplicateReferrer.setClient(oldEntity.getClient());
        duplicateReferrer.setId(oldEntity.getId());
        duplicateReferrer.setUri(null);
        Response r = this.putEntity((AbstractAuthzEntity)duplicateReferrer, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutDuplicate() throws Exception {
        String rawUrl = String.format("http://%s/redirect", RandomStringUtils.randomAlphabetic((int)10));
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext().getBuilder().referrer(rawUrl).referrer().build();
        ClientReferrer oldEntity = builder.getReferrer();
        ClientReferrer duplicateReferrer = new ClientReferrer();
        duplicateReferrer.setClient(oldEntity.getClient());
        duplicateReferrer.setId(oldEntity.getId());
        duplicateReferrer.setUri(URI.create(rawUrl));
        Response r = this.putEntity((AbstractAuthzEntity)duplicateReferrer, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testDeleteAdminApp() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Response r = this.deleteEntity((AbstractAuthzEntity)context.getReferrer(), this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testScopes() throws Exception {
        ClientReferrerService cs = new ClientReferrerService(IdUtil.next());
        Assert.assertEquals((Object)"kangaroo:client_admin", (Object)cs.getAdminScope());
        Assert.assertEquals((Object)"kangaroo:client", (Object)cs.getAccessScope());
    }
}

