/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractSubserviceCRUDTest;
import net.krotscheck.kangaroo.authz.admin.v1.resource.ClientRedirectService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class ClientRedirectServiceCRUDTest
extends AbstractSubserviceCRUDTest<Client, ClientRedirect> {
    private static final GenericType<ListResponseEntity<ClientRedirect>> LIST_TYPE = new GenericType<ListResponseEntity<ClientRedirect>>(){};

    public ClientRedirectServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Client.class, ClientRedirect.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:client_admin", false, true}, {ClientType.Implicit, "kangaroo:client", false, true}, {ClientType.Implicit, "kangaroo:client_admin", true, true}, {ClientType.Implicit, "kangaroo:client", true, false}, {ClientType.ClientCredentials, "kangaroo:client_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:client", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<ClientRedirect>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI getUrlForId(String id) {
        String parentId = "";
        Session s = this.getSession();
        s.getTransaction().begin();
        try {
            ClientRedirect r = (ClientRedirect)s.get(ClientRedirect.class, (Serializable)IdUtil.fromString((String)id));
            parentId = IdUtil.toString((BigInteger)r.getClient().getId());
        }
        catch (Exception e) {
            parentId = IdUtil.toString((BigInteger)this.getParentEntity(this.getAdminContext()).getId());
        }
        finally {
            s.getTransaction().commit();
        }
        return this.getUrlForEntity(parentId, id);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        String parentId = "";
        String childId = "";
        ClientRedirect redirect = (ClientRedirect)entity;
        if (redirect == null) {
            return this.getUrlForId(null);
        }
        BigInteger redirectId = redirect.getId();
        childId = redirectId == null ? null : IdUtil.toString((BigInteger)redirectId);
        Client client = redirect.getClient();
        if (client == null) {
            return this.getUrlForId(null);
        }
        BigInteger clientId = client.getId();
        parentId = clientId == null ? null : IdUtil.toString((BigInteger)clientId);
        return this.getUrlForEntity(parentId, childId);
    }

    private URI getUrlForEntity(String parentId, String childId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/client").path(parentId).path("redirect");
        if (childId != null) {
            builder.path(childId);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected Client getParentEntity(ApplicationBuilder.ApplicationContext context) {
        return this.getAttached(context.getClient());
    }

    @Override
    protected ClientRedirect createValidEntity(ApplicationBuilder.ApplicationContext context, Client parent) {
        ClientRedirect r = new ClientRedirect();
        r.setClient(parent);
        r.setUri(URI.create(String.format("http://%s.example.com", IdUtil.next())));
        return r;
    }

    @Override
    protected Client createParentEntity(ApplicationBuilder.ApplicationContext context) {
        Application a = this.getAttached(context.getApplication());
        Client c = new Client();
        c.setApplication(a);
        c.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        c.setType(ClientType.AuthorizationGrant);
        return c;
    }

    @Override
    protected ClientRedirect getEntity(ApplicationBuilder.ApplicationContext context) {
        return this.getAttached(context.getRedirect());
    }

    @Override
    protected ClientRedirect getNewEntity() {
        ClientRedirect newEntity = new ClientRedirect();
        newEntity.setClient(this.getAttached(this.getAdminContext().getClient()));
        return newEntity;
    }

    @Test
    public void testPostNoUri() throws Exception {
        ClientRedirect testEntity = (ClientRedirect)this.createValidEntity(this.getSecondaryContext());
        testEntity.setUri(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostDuplicate() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext();
        Client c = this.getAttached(this.getParentEntity(testContext));
        URI existing = ((ClientRedirect)c.getRedirects().get(0)).getUri();
        ClientRedirect testEntity = new ClientRedirect();
        testEntity.setClient(c);
        testEntity.setUri(existing);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPut() throws Exception {
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext();
        ClientRedirect oldEntity = builder.getRedirect();
        ClientRedirect cr = new ClientRedirect();
        cr.setClient(oldEntity.getClient());
        cr.setId(oldEntity.getId());
        cr.setUri(URI.create("http://new.example.com/redirect"));
        Response r = this.putEntity((AbstractAuthzEntity)cr, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            ClientRedirect response = (ClientRedirect)r.readEntity(ClientRedirect.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)cr, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutNoUri() throws Exception {
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext();
        ClientRedirect oldEntity = builder.getRedirect();
        ClientRedirect duplicateRedirect = new ClientRedirect();
        duplicateRedirect.setClient(oldEntity.getClient());
        duplicateRedirect.setId(oldEntity.getId());
        duplicateRedirect.setUri(null);
        Response r = this.putEntity((AbstractAuthzEntity)duplicateRedirect, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutDuplicate() throws Exception {
        String rawUrl = String.format("http://%s/redirect", RandomStringUtils.randomAlphabetic((int)10));
        ApplicationBuilder.ApplicationContext builder = this.getAdminContext().getBuilder().redirect(rawUrl).redirect().build();
        ClientRedirect oldEntity = builder.getRedirect();
        ClientRedirect duplicateRedirect = new ClientRedirect();
        duplicateRedirect.setClient(oldEntity.getClient());
        duplicateRedirect.setId(oldEntity.getId());
        duplicateRedirect.setUri(URI.create(rawUrl));
        Response r = this.putEntity((AbstractAuthzEntity)duplicateRedirect, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.CONFLICT);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testDeleteAdminApp() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Response r = this.deleteEntity((AbstractAuthzEntity)context.getRedirect(), this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testScopes() throws Exception {
        ClientRedirectService cs = new ClientRedirectService(IdUtil.next());
        Assert.assertEquals((Object)"kangaroo:client_admin", (Object)cs.getAdminScope());
        Assert.assertEquals((Object)"kangaroo:client", (Object)cs.getAccessScope());
    }
}

