/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractSubserviceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ClientRedirectServiceBrowseTest
extends AbstractSubserviceBrowseTest<Client, ClientRedirect> {
    private static final GenericType<ListResponseEntity<ClientRedirect>> LIST_TYPE = new GenericType<ListResponseEntity<ClientRedirect>>(){};

    public ClientRedirectServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:client_admin", false}, {ClientType.Implicit, "kangaroo:client", false}, {ClientType.Implicit, "kangaroo:client_admin", true}, {ClientType.Implicit, "kangaroo:client", true}, {ClientType.ClientCredentials, "kangaroo:client_admin", false}, {ClientType.ClientCredentials, "kangaroo:client", false});
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:client";
    }

    @Override
    protected GenericType<ListResponseEntity<ClientRedirect>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected Client getParentEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getClient();
    }

    @Override
    protected List<ClientRedirect> getAccessibleEntities(Client parentEntity, OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(parentEntity, attachedToken);
        }
        Criteria criteria = this.getSession().createCriteria(ClientRedirect.class).add((Criterion)Restrictions.eq((String)"client", (Object)parentEntity));
        return criteria.list();
    }

    @Override
    protected List<ClientRedirect> getOwnedEntities(Client parentEntity, User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getClients().stream()).filter(c -> c.equals((Object)parentEntity)).flatMap(c -> c.getRedirects().stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI getUrlForId(String id) {
        String parentId = "";
        Session s = this.getSession();
        s.getTransaction().begin();
        try {
            ClientRedirect r = (ClientRedirect)s.get(ClientRedirect.class, (Serializable)IdUtil.fromString((String)id));
            parentId = IdUtil.toString((BigInteger)r.getClient().getId());
        }
        catch (Exception e) {
            parentId = IdUtil.toString((BigInteger)this.getParentEntity(this.getAdminContext()).getId());
        }
        finally {
            s.getTransaction().commit();
        }
        return this.getUrlForEntity(parentId, id);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        String parentId = "";
        String childId = "";
        ClientRedirect referrer = (ClientRedirect)entity;
        if (referrer == null) {
            return this.getUrlForId(null);
        }
        BigInteger referrerId = referrer.getId();
        childId = referrerId == null ? null : referrerId.toString();
        Client client = referrer.getClient();
        if (client == null) {
            return this.getUrlForId(null);
        }
        BigInteger clientId = client.getId();
        parentId = clientId == null ? null : clientId.toString();
        return this.getUrlForEntity(parentId, childId);
    }

    private URI getUrlForEntity(String parentId, String childId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/client").path(parentId).path("redirect");
        if (childId != null) {
            builder.path(childId);
        }
        return builder.build(new Object[0]);
    }
}

