/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class AuthenticatorServiceSearchTest
extends AbstractServiceSearchTest<Authenticator> {
    private static final GenericType<ListResponseEntity<Authenticator>> LIST_TYPE = new GenericType<ListResponseEntity<Authenticator>>(){};

    public AuthenticatorServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(Authenticator.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:authenticator_admin", false}, {ClientType.Implicit, "kangaroo:authenticator", false}, {ClientType.Implicit, "kangaroo:authenticator_admin", true}, {ClientType.Implicit, "kangaroo:authenticator", true}, {ClientType.ClientCredentials, "kangaroo:authenticator_admin", false}, {ClientType.ClientCredentials, "kangaroo:authenticator", false});
    }

    @Override
    protected GenericType<ListResponseEntity<Authenticator>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<Authenticator> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications().stream().flatMap(a -> a.getClients().stream()).flatMap(c -> c.getAuthenticators().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"client.name"};
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:authenticator_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:authenticator";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/authenticator/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testSearchByClient() {
        String query = "many";
        Client c = (Client)this.getSecondaryContext().getApplication().getClients().stream().flatMap(client -> client.getAuthenticators().stream()).filter(auth -> auth.getType().equals((Object)AuthenticatorType.Test)).map(Authenticator::getClient).collect(Collectors.toList()).get(0);
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("client", IdUtil.toString((BigInteger)c.getId()));
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getClient().equals((Object)c)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.isAccessible((AbstractAuthzEntity)c, token)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidClient() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("client", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testSearchByMalformedApplication() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("client", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSearchByType() {
        String query = "many";
        Authenticator authenticator = this.getSecondaryContext().getAuthenticator();
        AuthenticatorType type = authenticator.getType();
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("type", type.toString());
        Response r = this.search(params, token);
        List searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).filter(item -> item.getType().equals((Object)type)).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public void testSearchByInvalidType() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("type", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

