/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public final class AuthenticatorServiceCRUDTest
extends AbstractServiceCRUDTest<Authenticator> {
    private static final GenericType<ListResponseEntity<Authenticator>> LIST_TYPE = new GenericType<ListResponseEntity<Authenticator>>(){};

    public AuthenticatorServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Authenticator.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:authenticator_admin", false, true}, {ClientType.Implicit, "kangaroo:authenticator", false, true}, {ClientType.Implicit, "kangaroo:authenticator_admin", true, true}, {ClientType.Implicit, "kangaroo:authenticator", true, false}, {ClientType.ClientCredentials, "kangaroo:authenticator_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:authenticator", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<Authenticator>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/authenticator/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Override
    protected Authenticator getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getAuthenticator();
    }

    @Override
    protected Authenticator getNewEntity() {
        return new Authenticator();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:authenticator_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:authenticator";
    }

    @Override
    protected Authenticator createValidEntity(ApplicationBuilder.ApplicationContext context) {
        Authenticator a = new Authenticator();
        a.setClient(context.getClient());
        a.setType(AuthenticatorType.Test);
        a.getConfiguration().put("foo", "bar");
        a.getConfiguration().put("lol", "cat");
        return a;
    }

    @Test
    public void testPostInvalidConfig() throws Exception {
        Authenticator testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.getConfiguration().put("invalid", "bar");
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST, "misconfigured");
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostNoParent() throws Exception {
        Authenticator testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setClient(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostInvalidParent() throws Exception {
        Authenticator testEntity = this.createValidEntity(this.getAdminContext());
        Client wrongParent = new Client();
        wrongParent.setId(IdUtil.next());
        testEntity.setClient(wrongParent);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoType() throws Exception {
        Authenticator testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setType(null);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPut() throws Exception {
        Authenticator a = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)a);
        s.getTransaction().commit();
        a.getConfiguration().put("foo", "baz");
        a.getConfiguration().put("zing", "zong");
        Response r = this.putEntity((AbstractAuthzEntity)a, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            Authenticator response = (Authenticator)r.readEntity(Authenticator.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)a, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
        s.getTransaction().begin();
        s.delete((Object)a);
        s.getTransaction().commit();
    }

    @Test
    public void testPutInvalidConfig() throws Exception {
        Authenticator a = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)a);
        s.getTransaction().commit();
        a.getConfiguration().put("invalid", "config");
        Response r = this.putEntity((AbstractAuthzEntity)a, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST, "misconfigured");
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
        s.getTransaction().begin();
        s.delete((Object)a);
        s.getTransaction().commit();
    }

    @Test
    public void testPutChangeParentEntity() throws Exception {
        Client newParent = this.getAdminContext().getClient();
        Authenticator entity = this.getEntity(this.getSecondaryContext());
        Assert.assertNotEquals((Object)newParent, (Object)entity.getClient());
        Authenticator authenticator = new Authenticator();
        authenticator.setId(entity.getId());
        authenticator.setType(entity.getType());
        authenticator.setClient(newParent);
        Response r = this.putEntity((AbstractAuthzEntity)authenticator, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)entity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutNoType() throws Exception {
        Authenticator entity = this.getEntity(this.getSecondaryContext());
        entity.setType(null);
        Response r = this.putEntity((AbstractAuthzEntity)entity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)entity, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

