/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceBrowseTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.hibernate.Criteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class AuthenticatorServiceBrowseTest
extends AbstractServiceBrowseTest<Authenticator> {
    private static final GenericType<ListResponseEntity<Authenticator>> LIST_TYPE = new GenericType<ListResponseEntity<Authenticator>>(){};

    public AuthenticatorServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:authenticator_admin", false}, {ClientType.Implicit, "kangaroo:authenticator", false}, {ClientType.Implicit, "kangaroo:authenticator_admin", true}, {ClientType.Implicit, "kangaroo:authenticator", true}, {ClientType.ClientCredentials, "kangaroo:authenticator_admin", false}, {ClientType.ClientCredentials, "kangaroo:authenticator", false});
    }

    @Override
    protected GenericType<ListResponseEntity<Authenticator>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:authenticator_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:authenticator";
    }

    @Override
    protected List<Authenticator> getAccessibleEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (!attachedToken.getScopes().containsKey(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        Criteria criteria = this.getSession().createCriteria(Application.class);
        return criteria.list().stream().flatMap(a -> a.getClients().stream()).flatMap(c -> c.getAuthenticators().stream()).collect(Collectors.toList());
    }

    @Override
    protected List<Authenticator> getOwnedEntities(User owner) {
        List<Authenticator> aList = owner.getApplications().stream().flatMap(a -> a.getClients().stream()).flatMap(c -> c.getAuthenticators().stream()).collect(Collectors.toList());
        return aList;
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/authenticator/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testBrowseFilterByClient() {
        Client c = this.getAdminContext().getClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client", IdUtil.toString((BigInteger)c.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List expectedResults = this.getAccessibleEntities(this.getAdminToken()).stream().filter(authenticator -> authenticator.getClient().equals((Object)c)).distinct().collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (this.isAccessible((AbstractAuthzEntity)c, this.getAdminToken())) {
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }
}

