/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceSearchTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ApplicationServiceSearchTest
extends AbstractServiceSearchTest<Application> {
    private static final GenericType<ListResponseEntity<Application>> LIST_TYPE = new GenericType<ListResponseEntity<Application>>(){};

    public ApplicationServiceSearchTest(ClientType clientType, String tokenScope, Boolean createUser) {
        super(Application.class, clientType, tokenScope, createUser);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:application_admin", false}, {ClientType.Implicit, "kangaroo:application", false}, {ClientType.Implicit, "kangaroo:application_admin", true}, {ClientType.Implicit, "kangaroo:application", true}, {ClientType.ClientCredentials, "kangaroo:application_admin", false}, {ClientType.ClientCredentials, "kangaroo:application", false});
    }

    @Override
    protected GenericType<ListResponseEntity<Application>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected List<Application> getOwnedEntities(User owner) {
        return this.getAttached(owner).getApplications();
    }

    @Override
    protected String[] getSearchIndexFields() {
        return new String[]{"name"};
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:application_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:application";
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/application/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }
}

