/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.admin.v1.resource.ApplicationService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ApplicationServiceCRUDTest
extends AbstractServiceCRUDTest<Application> {
    private static final GenericType<ListResponseEntity<Application>> LIST_TYPE = new GenericType<ListResponseEntity<Application>>(){};

    public ApplicationServiceCRUDTest(ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(Application.class, clientType, tokenScope, createUser, shouldSucceed);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({ClientType.Implicit, "kangaroo:application_admin", false, true}, {ClientType.Implicit, "kangaroo:application", false, true}, {ClientType.Implicit, "kangaroo:application_admin", true, true}, {ClientType.Implicit, "kangaroo:application", true, false}, {ClientType.ClientCredentials, "kangaroo:application_admin", false, true}, {ClientType.ClientCredentials, "kangaroo:application", false, false});
    }

    @Override
    protected GenericType<ListResponseEntity<Application>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected Application getEntity(ApplicationBuilder.ApplicationContext context) {
        return context.getApplication();
    }

    @Override
    protected Application getNewEntity() {
        return new Application();
    }

    @Override
    protected Application createValidEntity(ApplicationBuilder.ApplicationContext context) {
        Application a = new Application();
        a.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        a.setOwner(context.getOwner());
        return a;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:application_admin";
    }

    @Override
    protected String getRegularScope() {
        return "kangaroo:application";
    }

    @Override
    protected URI getUrlForId(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/application/");
        if (id != null) {
            builder.path(id);
        }
        return builder.build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        if (entity == null || entity.getId() == null) {
            return this.getUrlForId(null);
        }
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testPostOverwrite() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Application newApp = new Application();
        newApp.setId(this.getSecondaryContext().getApplication().getId());
        newApp.setName("New Application");
        newApp.setOwner(context.getUser());
        Response r = this.postEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostTooLongName() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Application newApp = new Application();
        newApp.setName(RandomStringUtils.randomAlphanumeric((int)257));
        newApp.setOwner(context.getUser());
        Response r = this.postEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostTooLongDescription() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Application newApp = new Application();
        newApp.setName(RandomStringUtils.randomAlphanumeric((int)32));
        newApp.setDescription(RandomStringUtils.randomAlphanumeric((int)257));
        newApp.setOwner(context.getUser());
        Response r = this.postEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostDefaultRoleFromOtherApp() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Application newApp = new Application();
        newApp.setName(RandomStringUtils.randomAlphanumeric((int)257));
        newApp.setOwner(context.getUser());
        newApp.setDefaultRole(context.getRole());
        Response r = this.postEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNonexistentDefaultRole() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Role defaultRole = new Role();
        defaultRole.setId(IdUtil.next());
        Application newApp = new Application();
        newApp.setName(RandomStringUtils.randomAlphanumeric((int)257));
        newApp.setOwner(context.getUser());
        newApp.setDefaultRole(defaultRole);
        Response r = this.postEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testPostNoOwner() throws Exception {
        OAuthToken token = this.getAdminToken();
        Application newApp = new Application();
        newApp.setName("New Application");
        Response r = this.postEntity((AbstractAuthzEntity)newApp, token);
        if (!token.getClient().getType().equals((Object)ClientType.ClientCredentials)) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            Application response = (Application)getResponse.readEntity(Application.class);
            Assert.assertNotNull((Object)response.getId());
            Assert.assertEquals((Object)newApp.getName(), (Object)response.getName());
            Assert.assertNotNull((Object)response.getOwner().getId());
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPostOwnerAssign() throws Exception {
        ApplicationBuilder.ApplicationContext testContext = this.getAdminContext().getBuilder().user().identity().build();
        OAuthToken token = this.getAdminToken();
        Application newApp = new Application();
        newApp.setName("New Application");
        newApp.setOwner(testContext.getUser());
        Response r = this.postEntity((AbstractAuthzEntity)newApp, token);
        if (this.getTokenScope().equals("kangaroo:application_admin")) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            Application response = (Application)getResponse.readEntity(Application.class);
            Assert.assertNotNull((Object)response.getId());
            Assert.assertEquals((Object)newApp.getName(), (Object)response.getName());
            Assert.assertEquals((Object)newApp.getOwner(), (Object)response.getOwner());
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public void testPutAdminApp() throws Exception {
        Application app = this.getAdminContext().getApplication();
        app.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.putEntity((AbstractAuthzEntity)app, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutRegularApp() throws Exception {
        Application a = this.getSecondaryContext().getApplication();
        a.setName(IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.putEntity((AbstractAuthzEntity)a, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            Application response = (Application)r.readEntity(Application.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)a, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutSetDefaultRole() throws Exception {
        Application newApp = this.createValidEntity(this.getAdminContext());
        Role newRole = new Role();
        newRole.setApplication(newApp);
        newRole.setName("name");
        Session s = this.getSession();
        Transaction t = s.beginTransaction();
        s.save((Object)newApp);
        s.save((Object)newRole);
        t.commit();
        Assert.assertNull((Object)newApp.getDefaultRole());
        newApp.setDefaultRole(newRole);
        Response r = this.putEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)newApp, this.getAdminToken())) {
            Application response = (Application)r.readEntity(Application.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)newApp, (Object)response);
            Assert.assertEquals((Object)newRole.getId(), (Object)response.getDefaultRole().getId());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutUpdateDefaultRole() throws Exception {
        Application newApp = this.createValidEntity(this.getAdminContext());
        Role originalRole = new Role();
        originalRole.setApplication(newApp);
        originalRole.setName("original");
        Role newRole = new Role();
        newRole.setApplication(newApp);
        newRole.setName("new");
        newApp.setDefaultRole(originalRole);
        Session s = this.getSession();
        Transaction t = s.beginTransaction();
        s.save((Object)newApp);
        s.save((Object)originalRole);
        s.save((Object)newRole);
        t.commit();
        Application testEntity = new Application();
        testEntity.setDefaultRole(newRole);
        testEntity.setName(newApp.getName());
        testEntity.setId(newApp.getId());
        testEntity.setOwner(newApp.getOwner());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            Application response = (Application)r.readEntity(Application.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
            Assert.assertEquals((Object)testEntity, (Object)response);
            Assert.assertEquals((Object)newRole.getId(), (Object)response.getDefaultRole().getId());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutEmptyDefaultRole() throws Exception {
        Application a = this.getSecondaryContext().getApplication();
        Assert.assertNotNull((Object)a.getDefaultRole());
        Application testEntity = new Application();
        testEntity.setDefaultRole(null);
        testEntity.setId(a.getId());
        testEntity.setName(a.getName());
        testEntity.setOwner(a.getOwner());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutInvalidDefaultRole() throws Exception {
        Application a = this.getSecondaryContext().getApplication();
        Role role = new Role();
        role.setId(IdUtil.next());
        Application testEntity = new Application();
        testEntity.setDefaultRole(role);
        testEntity.setId(a.getId());
        testEntity.setName(a.getName());
        testEntity.setOwner(a.getOwner());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutOtherAppDefaultRole() throws Exception {
        Application a = this.getSecondaryContext().getApplication();
        Application testEntity = new Application();
        testEntity.setDefaultRole(this.getAdminContext().getRole());
        testEntity.setId(a.getId());
        testEntity.setName(a.getName());
        testEntity.setOwner(a.getOwner());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)a, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testPutChangeOwner() throws Exception {
        User oldOwner = this.getAdminContext().getOwner();
        Application newApp = this.createValidEntity(this.getAdminContext());
        newApp.setOwner(oldOwner);
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save((Object)newApp);
        s.getTransaction().commit();
        User newOwner = this.getSecondaryContext().getOwner();
        newApp.setOwner(newOwner);
        Response r = this.putEntity((AbstractAuthzEntity)newApp, this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testDeleteAdminApp() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Response r = this.deleteEntity((AbstractAuthzEntity)context.getApplication(), this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public void testScopes() throws Exception {
        ApplicationService as = new ApplicationService();
        Assert.assertEquals((Object)"kangaroo:application_admin", (Object)as.getAdminScope());
        Assert.assertEquals((Object)"kangaroo:application", (Object)as.getAccessScope());
    }

    @Test
    public void test() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        Response r = this.deleteEntity((AbstractAuthzEntity)context.getApplication(), this.getAdminToken());
        if (this.shouldSucceed().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.FORBIDDEN);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }
}

