/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractServiceCRUDTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.runner.ParameterizedSingleInstanceTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedSingleInstanceTestRunner.ParameterizedSingleInstanceTestRunnerFactory.class)
public abstract class AbstractSubserviceCRUDTest<K extends AbstractAuthzEntity, T extends AbstractAuthzEntity>
extends AbstractServiceCRUDTest<T> {
    private final Class<K> parentClass;

    public AbstractSubserviceCRUDTest(Class<K> parentClass, Class<T> childClass, ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        super(childClass, clientType, tokenScope, createUser, shouldSucceed);
        this.parentClass = parentClass;
    }

    protected abstract K getParentEntity(ApplicationBuilder.ApplicationContext var1);

    @Override
    protected final T createValidEntity(ApplicationBuilder.ApplicationContext context) {
        K parent = this.getParentEntity(context);
        return this.createValidEntity(context, parent);
    }

    protected abstract T createValidEntity(ApplicationBuilder.ApplicationContext var1, K var2);

    protected abstract K createParentEntity(ApplicationBuilder.ApplicationContext var1);

    @Test
    public final void testGetDifferentParent() throws Exception {
        Object originalEntity = this.getEntity(this.getAdminContext());
        AbstractAuthzEntity testParent = (AbstractAuthzEntity)this.getParentEntity(this.getSecondaryContext()).clone();
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        testEntity.setId(originalEntity.getId());
        Response r = this.getEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testGetInvalidParent() throws Exception {
        AbstractAuthzEntity originalEntity = (AbstractAuthzEntity)this.getEntity(this.getAdminContext()).clone();
        K testParent = this.createParentEntity(this.getAdminContext());
        testParent.setId(IdUtil.next());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        testEntity.setId(originalEntity.getId());
        Response r = this.getEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testPostInvalidParent() throws Exception {
        K testParent = this.createParentEntity(this.getAdminContext());
        testParent.setId(IdUtil.next());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testPutDifferentParent() throws Exception {
        K testParent = this.getParentEntity(this.getSecondaryContext());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        Object validEntity = this.getEntity(this.getAdminContext());
        testEntity.setId(validEntity.getId());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testPutInvalidParent() throws Exception {
        K testParent = this.createParentEntity(this.getAdminContext());
        testParent.setId(IdUtil.next());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        Object validEntity = this.getEntity(this.getAdminContext());
        testEntity.setId(validEntity.getId());
        Response r = this.putEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testDeleteDifferentParent() throws Exception {
        K testParent = this.getParentEntity(this.getSecondaryContext());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        Object validEntity = this.getEntity(this.getAdminContext());
        testEntity.setId(validEntity.getId());
        Response r = this.deleteEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testDeleteInvalidParent() throws Exception {
        K testParent = this.createParentEntity(this.getAdminContext());
        testParent.setId(IdUtil.next());
        T testEntity = this.createValidEntity(this.getAdminContext(), testParent);
        Object validEntity = this.getEntity(this.getAdminContext());
        testEntity.setId(validEntity.getId());
        Response r = this.deleteEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

