/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.runner.ParameterizedSingleInstanceTestRunner;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedSingleInstanceTestRunner.ParameterizedSingleInstanceTestRunnerFactory.class)
public abstract class AbstractSubserviceBrowseTest<K extends AbstractAuthzEntity, T extends AbstractAuthzEntity>
extends AbstractResourceTest<T> {
    private final String tokenScope;
    private final ClientType clientType;
    private final Boolean createUser;
    private Client client;
    private OAuthToken adminAppToken;
    private ApplicationBuilder.ApplicationContext otherApp;
    private SingletonTestContainerFactory testContainerFactory;

    public AbstractSubserviceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        this.tokenScope = tokenScope;
        this.clientType = clientType;
        this.createUser = createUser;
    }

    protected final TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    protected abstract List<T> getAccessibleEntities(K var1, OAuthToken var2);

    protected abstract List<T> getOwnedEntities(K var1, User var2);

    protected final List<T> getAccessibleEntities(K parentEntity) {
        return this.getAccessibleEntities(parentEntity, this.getAdminToken());
    }

    protected final List<T> getOwnedEntities(K parentEntity) {
        if (this.getAdminToken().getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(parentEntity, this.getAdminToken().getIdentity().getUser());
    }

    protected final List<T> getOwnedEntities(K parentEntity, OAuthToken token) {
        if (token.getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(parentEntity, this.getAdminToken().getIdentity().getUser());
    }

    @Before
    public final void configureData() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        User owner = context.getOwner();
        this.client = context.getBuilder().client(this.clientType).build().getClient();
        if (this.createUser.booleanValue()) {
            owner = this.getSecondaryContext().getOwner();
        }
        UserIdentity identity = (UserIdentity)owner.getIdentities().iterator().next();
        this.adminAppToken = context.getBuilder().bearerToken(this.client, identity, this.tokenScope).build().getToken();
    }

    protected final OAuthToken getAdminToken() {
        return this.adminAppToken;
    }

    protected final OAuthToken getSecondaryToken() {
        return this.otherApp.getToken();
    }

    public final Client getAdminClient() {
        return this.client;
    }

    public final String getTokenScope() {
        return this.tokenScope;
    }

    protected final Boolean isLimitedByClientCredentials() {
        return this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope());
    }

    protected abstract K getParentEntity(ApplicationBuilder.ApplicationContext var1);

    @Test
    public final void testBrowse() {
        HashMap<String, String> params = new HashMap<String, String>();
        Response r = this.browse(params, this.adminAppToken);
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
        }
    }

    @Test
    public final void testBrowseLimit() {
        Integer limit = 2;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", limit.toString());
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            this.assertListResponse(r, Math.min(expectedResults, limit), 0, limit, expectedResults);
        }
    }

    @Test
    public final void testBrowseOffset() {
        Integer offset = 1;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offset", offset.toString());
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            this.assertListResponse(r, Math.min(expectedResults - offset, 10), offset, 10, expectedResults);
        }
    }

    @Test
    public final void testBrowseSortDefault() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e1.getCreatedDate().compareTo(e2.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseSortAscending() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "ASC");
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted(Comparator.comparing(AbstractEntity::getCreatedDate));
        }
    }

    @Test
    public final void testBrowseSortDescending() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "DESC");
        Response r = this.browse(params, this.adminAppToken);
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope())) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e2.getCreatedDate().compareTo(e1.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseSortInvalid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "invalid_sort");
        Response r = this.browse(params, this.adminAppToken);
        K parentEntity = this.getParentEntity(this.getAdminContext());
        Integer expectedResults = this.getAccessibleEntities(parentEntity, this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else if (!this.isAccessible((AbstractAuthzEntity)parentEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND.getStatusCode(), "not_found");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e1.getCreatedDate().compareTo(e2.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseNoAuth() {
        Response response = this.target(this.getBrowseUrl().getPath()).request().get();
        this.assertErrorResponse(response, Response.Status.UNAUTHORIZED);
    }
}

