/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public final class AbstractServiceTest
extends AbstractResourceTest {
    private static final GenericType<ListResponseEntity<AbstractEntity>> LIST_TYPE = new GenericType<ListResponseEntity<AbstractEntity>>(){};
    private static ApplicationBuilder.ApplicationContext userApp;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private SecurityContext mockContext;
    private AbstractService service;

    protected GenericType<ListResponseEntity<AbstractEntity>> getListType() {
        return LIST_TYPE;
    }

    @Before
    public void setupTestData() {
        this.mockContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        this.service = new TestService();
        this.service.setConfig(this.getSystemConfig());
        this.service.setSession(this.getSession());
        this.service.setFullTextSession(this.getFullTextSession());
        this.service.setSearchFactory(this.getSearchFactory());
        this.service.setSecurityContext(this.mockContext);
    }

    @Override
    protected String getAdminScope() {
        return null;
    }

    @Override
    protected String getRegularScope() {
        return null;
    }

    @Override
    protected URI getUrlForId(String id) {
        return UriBuilder.fromPath((String)"/application/").path(id).build(new Object[0]);
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return this.getUrlForId(IdUtil.toString((BigInteger)entity.getId()));
    }

    @Test
    public void testConstructor() {
        Configuration config = (Configuration)Mockito.mock(Configuration.class);
        UriInfo info = (UriInfo)Mockito.mock(UriInfo.class);
        Session session = (Session)Mockito.mock(Session.class);
        InjectionManager injector = (InjectionManager)Mockito.mock(InjectionManager.class);
        SearchFactory factory = (SearchFactory)Mockito.mock(SearchFactory.class);
        FullTextSession ftSession = (FullTextSession)Mockito.mock(FullTextSession.class);
        SecurityContext c = (SecurityContext)Mockito.mock(SecurityContext.class);
        TestService s = new TestService();
        s.setInjector(injector);
        s.setConfig(config);
        s.setSession(session);
        s.setSearchFactory(factory);
        s.setFullTextSession(ftSession);
        s.setSecurityContext(c);
        s.setUriInfo(info);
        Assert.assertEquals((Object)injector, (Object)s.getInjector());
        Assert.assertEquals((Object)session, (Object)s.getSession());
        Assert.assertEquals((Object)factory, (Object)s.getSearchFactory());
        Assert.assertEquals((Object)ftSession, (Object)s.getFullTextSession());
        Assert.assertEquals((Object)c, (Object)s.getSecurityContext());
        Assert.assertEquals((Object)config, (Object)s.getConfig());
        Assert.assertEquals((Object)info, (Object)s.getUriInfo());
    }

    @Test
    public void testGetCurrentUser() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().bearerToken().build();
        ((SecurityContext)Mockito.doReturn((Object)this.getAdminContext().getToken()).when((Object)this.mockContext)).getUserPrincipal();
        User user = this.service.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)adminContext.getToken().getIdentity().getUser(), (Object)user);
    }

    @Test
    public void testGetCurrentUserClientCredentials() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).bearerToken().build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        Assert.assertNull((Object)this.service.getCurrentUser());
    }

    @Test
    public void testGetAdminApplication() {
        Application a = this.service.getAdminApplication();
        Assert.assertEquals((Object)this.getAdminContext().getApplication(), (Object)a);
    }

    @Test(expected=NotFoundException.class)
    public void testAssertCanAccessNull() {
        this.service.assertCanAccess(null, "kangaroo:application_admin");
    }

    @Test
    public void testAssertCanAccessAsOwner() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().role("lol").user().identity("not_admin").bearerToken().build();
        ApplicationBuilder.ApplicationContext userContext = userApp.getBuilder().owner(adminContext.getUser()).build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        this.service.assertCanAccess((AbstractAuthzEntity)userContext.getApplication(), "kangaroo:application_admin");
    }

    @Test
    public void testAssertCanAccessNotOwnerValidScope() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().bearerToken("kangaroo:application_admin").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.assertCanAccess((AbstractAuthzEntity)userApp.getApplication(), "kangaroo:application_admin");
    }

    @Test(expected=NotFoundException.class)
    public void testAssertCanAccessNotOwnerInvalidScope() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)false).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.assertCanAccess((AbstractAuthzEntity)userApp.getApplication(), "kangaroo:application_admin");
    }

    @Test
    public void testAssertCanAccessClientCredentialsValidScope() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application_admin").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.assertCanAccess((AbstractAuthzEntity)userApp.getApplication(), "kangaroo:application_admin");
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=NotFoundException.class)
    public void testAssertCanAccessClientCredentialsInvalidScope() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)false).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.assertCanAccess((AbstractAuthzEntity)userApp.getApplication(), "kangaroo:application_admin");
    }

    @Test
    public void testRequestUserFilterAdminNoFilter() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        User user = this.service.resolveOwnershipFilter(null);
        Assert.assertNull((Object)user);
    }

    @Test(expected=BadRequestException.class)
    public void testRequestInvalidUserFilterAdminFilter() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").user().build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.resolveOwnershipFilter(IdUtil.next());
    }

    @Test
    public void testRequestUserFilterAdminFilter() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").user().build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        User requestedUser = adminContext.getUser();
        User user = this.service.resolveOwnershipFilter(requestedUser.getId());
        Assert.assertEquals((Object)requestedUser, (Object)user);
    }

    @Test
    public void testRequestUserFilterNonAdminNoFilter() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        User requestedUser = adminContext.getUser();
        User user = this.service.resolveOwnershipFilter(null);
        Assert.assertEquals((Object)adminContext.getUser(), (Object)user);
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRequestUserFilterNonAdminFilter() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").user().build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        User requestedUser = adminContext.getUser();
        this.service.resolveOwnershipFilter(requestedUser.getId());
    }

    @Test
    public void testRequestUserFilterNonAdminFilterSelf() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        User requestedUser = adminContext.getToken().getIdentity().getUser();
        User user = this.service.resolveOwnershipFilter(requestedUser.getId());
        Assert.assertEquals((Object)requestedUser, (Object)user);
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRequestUserFilterNonAdminClientCredentials() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        this.service.resolveOwnershipFilter(adminContext.getUser().getId());
    }

    @Test(expected=BadRequestException.class)
    public void testRequireEntityInputNullEntity() {
        this.service.requireEntityInput(Application.class, null);
    }

    @Test(expected=BadRequestException.class)
    public void testRequireEntityInputNoIdEntity() {
        this.service.requireEntityInput(Application.class, (AbstractAuthzEntity)new Application());
    }

    @Test
    public void testRequireValidEntity() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        Application a = (Application)this.service.requireEntityInput(Application.class, (AbstractAuthzEntity)userApp.getApplication());
        Assert.assertEquals((Object)userApp.getApplication(), (Object)a);
    }

    @Test
    public void testResolveFilterEntityNoEntityAdmin() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        Application result = (Application)this.service.resolveFilterEntity(Application.class, null);
        Assert.assertNull((Object)result);
    }

    @Test(expected=BadRequestException.class)
    public void testResolveFilterEntityNonexistentEntityIdAdmin() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        this.service.resolveFilterEntity(Application.class, IdUtil.next());
    }

    @Test
    public void testResolveFilterEntityValidEntityIdAdmin() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application_admin");
        Application a = (Application)this.service.resolveFilterEntity(Application.class, userApp.getApplication().getId());
        Assert.assertEquals((Object)userApp.getApplication(), (Object)a);
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testResolveFilterEntityInvalidScope() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:user");
        this.service.resolveFilterEntity(Application.class, userApp.getApplication().getId());
    }

    @Test
    public void testResolveFilterEntityNullEntityIdNonAdmin() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        Application a = (Application)this.service.resolveFilterEntity(Application.class, null);
        Assert.assertNull((Object)a);
    }

    @Test(expected=BadRequestException.class)
    public void testResolveFilterEntityNonexistentEntityIdNonAdmin() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.Implicit).authenticator(AuthenticatorType.Test).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        this.service.resolveFilterEntity(Application.class, IdUtil.next());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testResolveFilterEntityNoTokenIdentity() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().client(ClientType.ClientCredentials).bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        this.service.resolveFilterEntity(Application.class, adminContext.getApplication().getId());
    }

    @Test(expected=BadRequestException.class)
    public void testResolveFilterEntityNonAdminNonOwner() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().user().identity().build();
        ApplicationBuilder.ApplicationContext userContext = userApp.getBuilder().owner(adminContext.getUser()).build();
        adminContext = adminContext.getBuilder().user().identity().bearerToken("kangaroo:application").build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        this.service.resolveFilterEntity(Application.class, userContext.getApplication().getId());
    }

    @Test
    public void testResolveFilterEntityNonAdminOwner() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext().getBuilder().user().identity().bearerToken("kangaroo:application").build();
        ApplicationBuilder.ApplicationContext userContext = userApp.getBuilder().owner(adminContext.getUser()).build();
        ((SecurityContext)Mockito.doReturn((Object)adminContext.getToken()).when((Object)this.mockContext)).getUserPrincipal();
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.mockContext)).isUserInRole("kangaroo:application");
        Application a = (Application)this.service.resolveFilterEntity(Application.class, userContext.getApplication().getId());
        Assert.assertEquals((Object)adminContext.getUser(), (Object)a.getOwner());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                userApp = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Password).user().role("foo").identity("test_identity").bearerToken().build();
            }
        };
    }

    public static final class TestService
    extends AbstractService {
        protected String getAdminScope() {
            return "kangaroo:application_admin";
        }

        protected String getAccessScope() {
            return "kangaroo:application";
        }
    }
}

