/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.runner.ParameterizedSingleInstanceTestRunner;
import org.apache.lucene.search.Query;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedSingleInstanceTestRunner.ParameterizedSingleInstanceTestRunnerFactory.class)
public abstract class AbstractServiceSearchTest<T extends AbstractAuthzEntity>
extends AbstractResourceTest<T> {
    private final Class<T> typingClass;
    private final String tokenScope;
    private final ClientType clientType;
    private final Boolean createUser;
    private Client client;
    private OAuthToken adminAppToken;
    private SingletonTestContainerFactory testContainerFactory;

    public AbstractServiceSearchTest(Class<T> typingClass, ClientType clientType, String tokenScope, Boolean createUser) {
        this.typingClass = typingClass;
        this.tokenScope = tokenScope;
        this.clientType = clientType;
        this.createUser = createUser;
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    @Before
    public final void configureData() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext().getBuilder().client(this.clientType).build();
        this.client = context.getClient();
        User owner = context.getOwner();
        if (this.createUser.booleanValue()) {
            owner = this.getSecondaryContext().getOwner();
        }
        UserIdentity identity = (UserIdentity)owner.getIdentities().iterator().next();
        this.adminAppToken = context.getBuilder().bearerToken(this.client, identity, this.tokenScope).build().getToken();
    }

    protected final List<T> getAccessibleEntities() {
        return this.getAccessibleEntities(this.getAdminToken());
    }

    protected final List<T> getOwnedEntities() {
        if (this.getAdminToken().getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(this.getAdminToken().getIdentity().getUser());
    }

    protected final List<T> getOwnedEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (attachedToken.getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(attachedToken.getIdentity().getUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<T> getAccessibleEntities(OAuthToken token) {
        List clients;
        Session s = this.getSession();
        s.getTransaction().begin();
        OAuthToken attachedToken = (OAuthToken)s.get(OAuthToken.class, (Serializable)token.getId());
        Set scopes = attachedToken.getScopes().keySet();
        s.getTransaction().commit();
        if (!scopes.contains(this.getAdminScope())) {
            return this.getOwnedEntities(attachedToken);
        }
        s.getTransaction().begin();
        try {
            Criteria c = this.getSession().createCriteria(this.typingClass);
            clients = c.list();
        }
        finally {
            s.getTransaction().commit();
        }
        return clients;
    }

    protected abstract List<T> getOwnedEntities(User var1);

    protected abstract String[] getSearchIndexFields();

    protected final List<T> getSearchResults(String query) {
        QueryBuilder b = this.getSearchFactory().buildQueryBuilder().forEntity(this.typingClass).get();
        Query luceneQuery = ((TermMatchingContext)b.keyword().fuzzy().onFields(this.getSearchIndexFields()).ignoreFieldBridge()).matching((Object)query).createQuery();
        List results = this.getFullTextSession().createFullTextQuery(luceneQuery, new Class[]{this.typingClass}).list();
        return results;
    }

    protected final OAuthToken getAdminToken() {
        return this.adminAppToken;
    }

    protected final OAuthToken getSecondaryToken() {
        return this.getSecondaryContext().getToken();
    }

    protected final Boolean isLimitedByClientCredentials() {
        return this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope());
    }

    @Test
    public final void testSearchNoQuery() {
        HashMap<String, String> params = new HashMap<String, String>();
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testSearchStopWord() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "and");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testSearch() throws Exception {
        String query = "many";
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        Response r = this.search(params, token);
        List<T> searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 1 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public final void testSearchOffset() {
        String query = "many";
        Integer offset = 1;
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("offset", offset.toString());
        Response r = this.search(params, token);
        List<T> searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal - offset);
        Integer expectedOffset = offset;
        Integer expectedLimit = 10;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 1 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public final void testSearchLimit() {
        String query = "many";
        Integer limit = 1;
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("limit", limit.toString());
        Response r = this.search(params, token);
        List<T> searchResults = this.getSearchResults(query);
        List accessibleEntities = this.getAccessibleEntities(token);
        List expectedResults = searchResults.stream().filter(item -> accessibleEntities.indexOf(item) > -1).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = limit;
        Integer expectedOffset = 0;
        Integer expectedLimit = limit;
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 1 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public final void testSearchByOwner() {
        String query = "many";
        OAuthToken adminToken = this.getAdminToken();
        User secondaryOwner = this.getSecondaryContext().getOwner();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", query);
        params.put("owner", IdUtil.toString((BigInteger)secondaryOwner.getId()));
        List<T> searchResults = this.getSearchResults(query);
        List ownedEntities = this.getOwnedEntities(secondaryOwner);
        List accessibleEntities = this.getAccessibleEntities(adminToken);
        List expectedResults = searchResults.stream().filter(item -> ownedEntities.indexOf(item) > -1).filter(item -> accessibleEntities.indexOf(item) > -1).collect(Collectors.toList());
        Integer expectedTotal = expectedResults.size();
        int expectedResultSize = Math.min(10, expectedTotal);
        Integer expectedOffset = 0;
        Integer expectedLimit = 10;
        Response r = this.search(params, adminToken);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else if (!this.getAdminScope().equals(this.tokenScope) && !adminToken.getIdentity().getUser().equals((Object)secondaryOwner)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        }
    }

    @Test
    public final void testSearchBySelf() {
        String query = "single";
        OAuthToken adminToken = this.getAdminToken();
        if (adminToken.getIdentity() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("owner", IdUtil.toString((BigInteger)adminToken.getIdentity().getUser().getId()));
            List<T> searchResults = this.getSearchResults(query);
            List ownedEntities = this.getOwnedEntities(adminToken);
            List expectedResults = searchResults.stream().filter(item -> ownedEntities.indexOf(item) > -1).collect(Collectors.toList());
            Integer expectedTotal = expectedResults.size();
            int expectedResultSize = Math.min(10, expectedTotal);
            Integer expectedOffset = 0;
            Integer expectedLimit = 10;
            Response r = this.search(params, adminToken);
            Assert.assertTrue((expectedTotal > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, expectedResultSize, expectedOffset, expectedLimit, expectedTotal);
        } else {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public final void testSearchByInvalidOwner() {
        OAuthToken token = this.getAdminToken();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "many");
        params.put("owner", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.search(params, token);
        if (this.tokenScope.equals(this.getAdminScope())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        }
    }

    @Test
    public final void testSearchByMalformedOwner() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "single");
        params.put("owner", "malformed");
        Response r = this.search(params, this.getAdminToken());
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testSearchNoResults() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "lolcat");
        Response r = this.search(params, this.getAdminToken());
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertListResponse(r, 0, 0, 10, 0);
        }
    }

    @Test
    public final void testSearchNoAuth() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "single");
        Response r = this.search(params, null);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }
}

