/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.runner.ParameterizedSingleInstanceTestRunner;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedSingleInstanceTestRunner.ParameterizedSingleInstanceTestRunnerFactory.class)
public abstract class AbstractServiceCRUDTest<T extends AbstractAuthzEntity>
extends AbstractResourceTest<T> {
    private final Class<T> typingClass;
    private final String tokenScope;
    private final ClientType clientType;
    private final Boolean createUser;
    private final Boolean shouldSucceed;
    private Client client;
    private OAuthToken adminAppToken;
    private SingletonTestContainerFactory testContainerFactory;

    public AbstractServiceCRUDTest(Class<T> typingClass, ClientType clientType, String tokenScope, Boolean createUser, Boolean shouldSucceed) {
        this.typingClass = typingClass;
        this.tokenScope = tokenScope;
        this.clientType = clientType;
        this.createUser = createUser;
        this.shouldSucceed = shouldSucceed;
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    @Before
    public final void configureData() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext();
        User owner = context.getOwner();
        this.client = context.getBuilder().client(this.clientType).build().getClient();
        if (this.createUser.booleanValue()) {
            owner = this.getSecondaryContext().getOwner();
        }
        UserIdentity identity = (UserIdentity)owner.getIdentities().iterator().next();
        this.adminAppToken = context.getBuilder().bearerToken(this.client, identity, this.tokenScope).build().getToken();
    }

    protected abstract T getEntity(ApplicationBuilder.ApplicationContext var1);

    protected abstract T getNewEntity();

    protected abstract T createValidEntity(ApplicationBuilder.ApplicationContext var1);

    protected final OAuthToken getAdminToken() {
        return this.adminAppToken;
    }

    protected final OAuthToken getSecondaryToken() {
        return this.getSecondaryContext().getToken();
    }

    public final Client getAdminClient() {
        return this.client;
    }

    protected final Boolean shouldSucceed() {
        return this.shouldSucceed;
    }

    public final String getTokenScope() {
        return this.tokenScope;
    }

    public final ClientType getClientType() {
        return this.clientType;
    }

    protected final Boolean isLimitedByClientCredentials() {
        return this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope());
    }

    @Test
    public final void testGetAdmin() throws Exception {
        T testingEntity = this.getEntity(this.getAdminContext());
        Response r = this.getEntity((AbstractAuthzEntity)testingEntity, this.adminAppToken);
        if (this.shouldSucceed.booleanValue()) {
            AbstractAuthzEntity response = (AbstractAuthzEntity)r.readEntity(this.typingClass);
            Assert.assertEquals(testingEntity, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public final void testGetRegularApp() throws Exception {
        T testingEntity = this.getEntity(this.getSecondaryContext());
        Response r = this.getEntity((AbstractAuthzEntity)testingEntity, this.adminAppToken);
        if (this.isAccessible((AbstractAuthzEntity)testingEntity, this.adminAppToken)) {
            AbstractAuthzEntity response = (AbstractAuthzEntity)r.readEntity(this.typingClass);
            Assert.assertEquals(testingEntity, (Object)response);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public final void testGetFromExternalApp() throws Exception {
        T testingEntity = this.getEntity(this.getAdminContext());
        OAuthToken token = this.getSecondaryContext().getToken();
        Response r = this.getEntity((AbstractAuthzEntity)testingEntity, token);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testGetByUnknown() throws Exception {
        T testingEntity = this.getEntity(this.getAdminContext());
        Response r = this.getEntity((AbstractAuthzEntity)testingEntity, null);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testGetMalformedId() throws Exception {
        Response r = this.getEntity("malformed_id", HttpUtil.authHeaderBearer((String)IdUtil.toString((BigInteger)this.adminAppToken.getId())));
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testGetNonexistent() throws Exception {
        Response r = this.getEntity(IdUtil.toString((BigInteger)IdUtil.next()), HttpUtil.authHeaderBearer((String)IdUtil.toString((BigInteger)this.adminAppToken.getId())));
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testPost() throws Exception {
        T testEntity = this.createValidEntity(this.getAdminContext());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.adminAppToken);
        if (this.shouldSucceed().booleanValue()) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.adminAppToken);
            AbstractAuthzEntity response = (AbstractAuthzEntity)getResponse.readEntity(this.typingClass);
            this.assertContentEquals((AbstractAuthzEntity)testEntity, response);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public final void testPostNoBody() throws Exception {
        Response r = this.postEntity(null, this.adminAppToken);
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testPostWithId() throws Exception {
        T testEntity = this.createValidEntity(this.getAdminContext());
        testEntity.setId(IdUtil.next());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.adminAppToken);
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testPostOtherParent() throws Exception {
        T testEntity = this.createValidEntity(this.getSecondaryContext());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getAdminToken());
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.getAdminToken())) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.getAdminToken());
            AbstractAuthzEntity response = (AbstractAuthzEntity)getResponse.readEntity(this.typingClass);
            Assert.assertNotNull((Object)response.getId());
            this.assertContentEquals((AbstractAuthzEntity)testEntity, response);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public final void testPostNoEntity() throws Exception {
        Response r = this.postEntity(null, this.adminAppToken);
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testPostExternalCredentials() throws Exception {
        T testEntity = this.createValidEntity(this.getAdminContext());
        Response r = this.postEntity((AbstractAuthzEntity)testEntity, this.getSecondaryContext().getToken());
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testPostDifferentApplication() throws Exception {
        ApplicationBuilder.ApplicationContext thirdApp = ApplicationBuilder.newApplication(this.getSession()).client(this.getClientType()).redirect("http://third.example.org/redirect").referrer("http://third.example.org/referrer").authenticator(AuthenticatorType.Password).user().identity().build();
        T testingEntity = this.createValidEntity(thirdApp);
        Response r = this.postEntity((AbstractAuthzEntity)testingEntity, this.adminAppToken);
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else if (testingEntity instanceof Application && this.adminAppToken.getIdentity() == null) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else if (this.tokenScope.equals(this.getAdminScope()) || testingEntity instanceof Application) {
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
            Assert.assertNotNull((Object)r.getLocation());
            Response getResponse = this.getEntity(r.getLocation(), this.adminAppToken);
            AbstractAuthzEntity responseEntity = (AbstractAuthzEntity)getResponse.readEntity(this.typingClass);
            Assert.assertNotNull((Object)responseEntity.getId());
            Assert.assertNotNull((Object)responseEntity.getCreatedDate());
            Assert.assertNotNull((Object)responseEntity.getModifiedDate());
            this.assertContentEquals((AbstractAuthzEntity)testingEntity, responseEntity);
        } else {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        }
    }

    @Test
    public final void testPostByUnknown() throws Exception {
        T testingEntity = this.createValidEntity(this.getAdminContext());
        Response r = this.postEntity((AbstractAuthzEntity)testingEntity, (OAuthToken)null);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testPutChangeId() throws Exception {
        Session s = this.getSession();
        T testEntity = this.createValidEntity(this.getSecondaryContext());
        s.getTransaction().begin();
        s.save(testEntity);
        s.getTransaction().commit();
        s.evict(testEntity);
        BigInteger oldId = testEntity.getId();
        testEntity.setId(IdUtil.next());
        Response r = this.putEntity(IdUtil.toString((BigInteger)oldId), (AbstractAuthzEntity)testEntity, HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId()));
        if (this.isAccessible((AbstractAuthzEntity)testEntity, this.adminAppToken)) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public final void testPutFromExternalApp() throws Exception {
        T testingEntity = this.getEntity(this.getSecondaryContext());
        OAuthToken token = this.getSecondaryContext().getToken();
        Response r = this.putEntity((AbstractAuthzEntity)testingEntity, token);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testPutByUnknown() throws Exception {
        T testingEntity = this.getEntity(this.getSecondaryContext());
        Response r = this.putEntity((AbstractAuthzEntity)testingEntity, null);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testPutMalformedId() throws Exception {
        Response r = this.putEntity("malformed_id", (AbstractAuthzEntity)this.getNewEntity(), HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId()));
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testPutNonexistent() throws Exception {
        T testingEntity = this.getNewEntity();
        testingEntity.setId(IdUtil.next());
        Response r = this.putEntity((AbstractAuthzEntity)testingEntity, this.adminAppToken);
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testDeleteRegularEntity() throws Exception {
        T testingEntity = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save(testingEntity);
        s.getTransaction().commit();
        Response r = this.deleteEntity((AbstractAuthzEntity)testingEntity, this.adminAppToken);
        if (this.isAccessible((AbstractAuthzEntity)testingEntity, this.adminAppToken)) {
            Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)r.getStatus());
        } else {
            this.assertErrorResponse(r, Response.Status.NOT_FOUND);
        }
    }

    @Test
    public final void testDeleteFromExternalApp() throws Exception {
        T testingEntity = this.getEntity(this.getAdminContext());
        Response r = this.deleteEntity((AbstractAuthzEntity)testingEntity, this.getSecondaryContext().getToken());
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testDeleteByUnknown() throws Exception {
        T testingEntity = this.createValidEntity(this.getSecondaryContext());
        Session s = this.getSession();
        s.getTransaction().begin();
        s.save(testingEntity);
        s.getTransaction().commit();
        Response r = this.deleteEntity((AbstractAuthzEntity)testingEntity, null);
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED);
    }

    @Test
    public final void testDeleteMalformedId() throws Exception {
        Response r = this.deleteEntity("malformed_id", HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId()));
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }

    @Test
    public final void testDeleteNonexistent() throws Exception {
        Response r = this.deleteEntity(IdUtil.toString((BigInteger)IdUtil.next()), HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId()));
        this.assertErrorResponse(r, Response.Status.NOT_FOUND);
    }
}

