/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.runner.ParameterizedSingleInstanceTestRunner;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedSingleInstanceTestRunner.ParameterizedSingleInstanceTestRunnerFactory.class)
public abstract class AbstractServiceBrowseTest<T extends AbstractAuthzEntity>
extends AbstractResourceTest<T> {
    private final String tokenScope;
    private final ClientType clientType;
    private final Boolean createUser;
    private Client client;
    private OAuthToken adminAppToken;
    private SingletonTestContainerFactory testContainerFactory;

    public AbstractServiceBrowseTest(ClientType clientType, String tokenScope, Boolean createUser) {
        this.tokenScope = tokenScope;
        this.clientType = clientType;
        this.createUser = createUser;
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    @Before
    public final void configureData() throws Exception {
        ApplicationBuilder.ApplicationContext context = this.getAdminContext().getBuilder().client(this.clientType).build();
        this.client = context.getClient();
        User owner = context.getOwner();
        if (this.createUser.booleanValue()) {
            owner = this.getSecondaryContext().getOwner();
        }
        UserIdentity identity = (UserIdentity)owner.getIdentities().iterator().next();
        this.adminAppToken = context.getBuilder().bearerToken(this.client, identity, this.tokenScope).build().getToken();
    }

    protected abstract List<T> getAccessibleEntities(OAuthToken var1);

    protected abstract List<T> getOwnedEntities(User var1);

    protected final List<T> getAccessibleEntities() {
        return this.getAccessibleEntities(this.getAdminToken());
    }

    protected final List<T> getOwnedEntities() {
        if (this.getAdminToken().getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(this.getAdminToken().getIdentity().getUser());
    }

    protected final List<T> getOwnedEntities(OAuthToken token) {
        OAuthToken attachedToken = this.getAttached(token);
        if (token.getIdentity() == null) {
            return Collections.emptyList();
        }
        return this.getOwnedEntities(attachedToken.getIdentity().getUser());
    }

    protected final OAuthToken getAdminToken() {
        return this.adminAppToken;
    }

    public final Client getAdminClient() {
        return this.client;
    }

    public final String getTokenScope() {
        return this.tokenScope;
    }

    protected final Boolean isLimitedByClientCredentials() {
        return this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope());
    }

    @Test
    public final void testBrowse() {
        HashMap<String, String> params = new HashMap<String, String>();
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
        }
    }

    @Test
    public final void testBrowseLimit() {
        Integer limit = 2;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", limit.toString());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            List list = this.assertListResponse(r, Math.min(expectedResults, limit), 0, limit, expectedResults);
        }
    }

    @Test
    public final void testBrowseOffset() {
        Integer offset = 1;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offset", offset.toString());
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            this.assertListResponse(r, Math.min(expectedResults - offset, 10), offset, 10, expectedResults);
        }
    }

    @Test
    public final void testBrowseSortDefault() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e1.getCreatedDate().compareTo(e2.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseSortAscending() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "ASC");
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e1.getCreatedDate().compareTo(e2.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseSortDescending() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "DESC");
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.clientType.equals((Object)ClientType.ClientCredentials) && this.tokenScope.equals(this.getRegularScope())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e2.getCreatedDate().compareTo(e1.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseSortInvalid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sort", "createdDate");
        params.put("order", "invalid_sort");
        Response r = this.browse(params, this.adminAppToken);
        Integer expectedResults = this.getAccessibleEntities(this.adminAppToken).size();
        if (this.isLimitedByClientCredentials().booleanValue()) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            List results = this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
            results.stream().sorted((e1, e2) -> e1.getCreatedDate().compareTo(e2.getCreatedDate()));
        }
    }

    @Test
    public final void testBrowseFilterByOwner() {
        User owner = this.getAdminContext().getApplication().getOwner();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("owner", IdUtil.toString((BigInteger)owner.getId()));
        Response r = this.browse(params, this.getAdminToken());
        List<T> accessibleEntities = this.getAccessibleEntities(this.getAdminToken());
        List expectedEntities = accessibleEntities.stream().filter(e -> owner.equals((Object)e.getOwner())).collect(Collectors.toList());
        Integer expectedResults = expectedEntities.size();
        if (this.isLimitedByClientCredentials().booleanValue() || !this.isAccessible((AbstractAuthzEntity)owner, this.getAdminToken())) {
            this.assertErrorResponse(r, Response.Status.BAD_REQUEST.getStatusCode(), "invalid_scope");
        } else {
            Assert.assertTrue((expectedResults > 0 ? 1 : 0) != 0);
            this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
        }
    }

    @Test
    public final void testBrowseFilterByMalformedOwner() {
        Response response = this.target(this.getBrowseUrl().getPath()).queryParam("owner", new Object[]{"malformed1"}).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId())).get();
        this.assertErrorResponse(response, Response.Status.BAD_REQUEST);
    }

    @Test
    public final void testBrowseBySelf() {
        if (this.adminAppToken.getIdentity() != null) {
            Response r = this.target(this.getBrowseUrl().getPath()).queryParam("owner", new Object[]{IdUtil.toString((BigInteger)this.adminAppToken.getIdentity().getUser().getId())}).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.adminAppToken.getId())).get();
            Integer expectedResults = this.getOwnedEntities(this.adminAppToken).size();
            Assert.assertEquals((long)200L, (long)r.getStatus());
            this.assertListResponse(r, Math.min(expectedResults, 10), 0, 10, expectedResults);
        } else {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public final void testBrowseNoAuth() {
        Response response = this.target(this.getBrowseUrl().getPath()).request().get();
        this.assertErrorResponse(response, Response.Status.UNAUTHORIZED);
    }
}

