/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.persistence.Transient;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.AdminV1API;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.authenticator.test.TestAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.hibernate.collection.internal.PersistentSortedMap;
import org.hibernate.internal.SessionImpl;
import org.junit.Assert;
import org.junit.ClassRule;

public abstract class AbstractResourceTest<T extends AbstractEntity>
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);
    private ResourceConfig testApplication;

    protected abstract GenericType<ListResponseEntity<T>> getListType();

    protected final ResourceConfig createApplication() {
        if (this.testApplication == null) {
            this.testApplication = new AdminV1API();
            this.testApplication.register((Object)new TestAuthenticator.Binder());
        }
        return this.testApplication;
    }

    public final ApplicationBuilder.ApplicationContext getAdminContext() {
        return TEST_DATA_RESOURCE.getAdminApplication();
    }

    protected final ApplicationBuilder.ApplicationContext getSecondaryContext() {
        return TEST_DATA_RESOURCE.getSecondaryApplication();
    }

    protected final Configuration getSystemConfig() {
        return TEST_DATA_RESOURCE.getSystemConfiguration();
    }

    protected abstract String getAdminScope();

    protected abstract String getRegularScope();

    protected final Response getEntity(AbstractAuthzEntity entity, OAuthToken token) {
        URI location = this.getUrlForEntity(entity);
        String authHeader = null;
        if (token != null) {
            authHeader = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        }
        return this.getEntity(location, authHeader);
    }

    protected final Response getEntity(String id, String authHeader) {
        URI location = this.getUrlForId(id);
        return this.getEntity(location, authHeader);
    }

    protected final Response getEntity(URI location, OAuthToken token) {
        String authHeader = null;
        if (token != null) {
            authHeader = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        }
        return this.getEntity(location, authHeader);
    }

    protected final Response getEntity(URI location, String authHeader) {
        Invocation.Builder t = this.target(location.getPath()).request();
        if (!StringUtils.isEmpty((CharSequence)authHeader)) {
            t.header("Authorization", (Object)authHeader);
        }
        return t.get();
    }

    protected final Response postEntity(AbstractAuthzEntity entity, OAuthToken token) {
        String authHeader = null;
        if (token != null) {
            authHeader = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        }
        return this.postEntity(entity, authHeader);
    }

    protected final Response postEntity(AbstractAuthzEntity entity, String authHeader) {
        URI location = this.getUrlForId("");
        if (entity != null) {
            BigInteger oldId = entity.getId();
            entity.setId(null);
            location = this.getUrlForEntity(entity);
            entity.setId(oldId);
        }
        Invocation.Builder t = this.target(location.getPath()).request();
        if (!StringUtils.isEmpty((CharSequence)authHeader)) {
            t.header("Authorization", (Object)authHeader);
        }
        Entity postEntity = Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        return t.post(postEntity);
    }

    protected final Response putEntity(AbstractAuthzEntity entity, OAuthToken token) {
        URI location = this.getUrlForEntity(entity);
        String authHeader = null;
        if (token != null) {
            authHeader = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        }
        return this.putEntity(location, entity, authHeader);
    }

    protected final Response putEntity(String id, AbstractAuthzEntity entity, String authHeader) {
        URI location = this.getUrlForId(id);
        return this.putEntity(location, entity, authHeader);
    }

    protected final Response putEntity(URI location, AbstractAuthzEntity entity, String authHeader) {
        Invocation.Builder t = this.target(location.getPath()).request();
        if (!StringUtils.isEmpty((CharSequence)authHeader)) {
            t.header("Authorization", (Object)authHeader);
        }
        Entity putEntity = Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        return t.put(putEntity);
    }

    protected final Response deleteEntity(AbstractAuthzEntity entity, OAuthToken token) {
        String authHeader = null;
        if (token != null) {
            authHeader = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        }
        URI location = this.getUrlForEntity(entity);
        return this.deleteEntity(location, authHeader);
    }

    protected final Response deleteEntity(String appId, String authHeader) {
        URI location = this.getUrlForId(appId);
        return this.deleteEntity(location, authHeader);
    }

    protected final Response deleteEntity(URI location, String authHeader) {
        Invocation.Builder t = this.target(location.getPath()).request();
        if (!StringUtils.isEmpty((CharSequence)authHeader)) {
            t.header("Authorization", (Object)authHeader);
        }
        return t.delete();
    }

    protected final Response browse(Map<String, String> params, OAuthToken token) {
        WebTarget t = this.target(this.getBrowseUrl().getPath());
        for (Map.Entry<String, String> e : params.entrySet()) {
            t = t.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        Invocation.Builder b = t.request();
        if (token != null) {
            b = b.header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId()));
        }
        return b.get();
    }

    protected final Response search(Map<String, String> params, OAuthToken token) {
        WebTarget t = this.target(this.getSearchUrl().getPath());
        for (Map.Entry<String, String> e : params.entrySet()) {
            t = t.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        Invocation.Builder b = t.request();
        if (token != null) {
            b = b.header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId()));
        }
        return b.get();
    }

    protected abstract URI getUrlForId(String var1);

    protected abstract URI getUrlForEntity(AbstractAuthzEntity var1);

    protected final URI getBrowseUrl() {
        return this.getUrlForId("");
    }

    protected final URI getSearchUrl() {
        return this.getUrlForId("search");
    }

    protected final boolean isAccessible(AbstractAuthzEntity entity, OAuthToken token) {
        return this.isAccessible(entity, token, this.getAdminScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isAccessible(AbstractAuthzEntity entity, OAuthToken token, String adminScope) {
        SessionImpl session = (SessionImpl)((PersistentSortedMap)token.getScopes()).getSession();
        session.beginTransaction();
        try {
            if (token.getScopes().containsKey(adminScope)) {
                boolean bl = true;
                return bl;
            }
            if (token.getIdentity() == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = token.getIdentity().getUser().equals((Object)entity.getOwner());
            return bl;
        }
        finally {
            session.getTransaction().commit();
        }
    }

    protected final void assertContentEquals(AbstractAuthzEntity left, AbstractAuthzEntity right) {
        HashSet<String> omittedFields = new HashSet<String>();
        omittedFields.add("id");
        omittedFields.add("createdDate");
        omittedFields.add("modifiedDate");
        omittedFields.add("owner");
        omittedFields.add("password");
        omittedFields.add("redirects");
        omittedFields.add("referrers");
        if (left instanceof ClientRedirect || left instanceof ClientReferrer) {
            omittedFields.add("client");
        }
        Assert.assertEquals(left.getClass(), right.getClass());
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(left.getClass()).getPropertyDescriptors()) {
                Method readMethod;
                List annotations;
                if (omittedFields.contains(descriptor.getName()) || (annotations = Arrays.asList((readMethod = descriptor.getReadMethod()).getDeclaredAnnotations()).stream().filter(a -> a.annotationType().equals(Transient.class) || a.annotationType().equals(JsonIgnore.class)).collect(Collectors.toList())).size() > 0) continue;
                Object leftValue = readMethod.invoke((Object)left, new Object[0]);
                Object rightValue = readMethod.invoke((Object)right, new Object[0]);
                Assert.assertEquals((Object)leftValue, (Object)rightValue);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
    }

    protected final List<T> assertListResponse(Response r, Integer expectedResultCount, Integer offset, Integer limit, Integer total) {
        ListResponseEntity results = (ListResponseEntity)r.readEntity(this.getListType());
        Assert.assertEquals((long)200L, (long)r.getStatus());
        Assert.assertEquals((Object)offset.toString(), (Object)r.getHeaderString("Offset"));
        Assert.assertEquals((Object)offset, (Object)results.getOffset());
        Assert.assertEquals((Object)limit.toString(), (Object)r.getHeaderString("Limit"));
        Assert.assertEquals((Object)limit, (Object)results.getLimit());
        Assert.assertEquals((Object)total.toString(), (Object)r.getHeaderString("Total"));
        Assert.assertEquals((Object)total, (Object)results.getTotal());
        Assert.assertEquals((long)expectedResultCount.intValue(), (long)results.getResults().size());
        return results.getResults();
    }

    protected final <T extends AbstractAuthzEntity> T getAttached(T instance) {
        return (T)((AbstractAuthzEntity)this.getSession().get(instance.getClass(), (Serializable)instance.getId()));
    }

    protected final <T extends AbstractAuthzEntity> List<T> getAttached(List<T> instances) {
        ArrayList<AbstractAuthzEntity> attached = new ArrayList<AbstractAuthzEntity>();
        for (AbstractAuthzEntity instance : instances) {
            attached.add(this.getAttached(instance));
        }
        return attached;
    }

    protected final <T extends AbstractAuthzEntity> SortedMap<String, T> getAttached(SortedMap<String, T> instances) {
        TreeMap<String, AbstractAuthzEntity> attached = new TreeMap<String, AbstractAuthzEntity>();
        for (Map.Entry<String, T> entry : instances.entrySet()) {
            attached.put(entry.getKey(), this.getAttached((AbstractAuthzEntity)entry.getValue()));
        }
        return attached;
    }
}

