/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.filter;

import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractResourceTest;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class OAuth2AuthenticationFilterTest
extends AbstractResourceTest {
    private static final GenericType<ListResponseEntity<AbstractEntity>> LIST_TYPE = new GenericType<ListResponseEntity<AbstractEntity>>(){};
    private OAuthToken validBearerToken;
    private OAuthToken noScopeBearerToken;
    private OAuthToken expiredBearerToken;
    private OAuthToken authToken;

    protected GenericType<ListResponseEntity<AbstractEntity>> getListType() {
        return LIST_TYPE;
    }

    @Override
    protected String getAdminScope() {
        return null;
    }

    @Override
    protected String getRegularScope() {
        return null;
    }

    @Before
    public void setupData() {
        ApplicationBuilder.ApplicationContext adminContext = this.getAdminContext();
        ApplicationBuilder b = adminContext.getBuilder().user(null).identity("remote_identity");
        ApplicationBuilder.ApplicationContext testContext = b.token(OAuthTokenType.Bearer, false, "kangaroo:user", null, null).build();
        this.validBearerToken = testContext.getToken();
        testContext = b.token(OAuthTokenType.Bearer, false, null, null, null).build();
        this.noScopeBearerToken = testContext.getToken();
        testContext = b.token(OAuthTokenType.Bearer, true, "kangaroo:user", null, null).build();
        this.expiredBearerToken = testContext.getToken();
        testContext = b.token(OAuthTokenType.Authorization, false, "kangaroo:user", null, null).build();
        this.authToken = testContext.getToken();
    }

    @Test
    public void testValidBearerToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.validBearerToken.getId())).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNoAuthHeader() {
        Response r = this.target("/user").request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidBearerTokenWithoutScope() {
        Response r = this.target("/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.noScopeBearerToken.getId())).get();
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testExpiredBearerToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.expiredBearerToken.getId())).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNonexistentBearerToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)IdUtil.toString((BigInteger)IdUtil.next()))).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testMalformedBearerToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)"Bearer YUIIUYIY").get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testAuthorizationToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)this.authToken.getId())).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testWrongPrefixTokenToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)String.format("HMAC %s", this.authToken.getId())).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testMalformedToken() {
        Response r = this.target("/user").request().header("Authorization", (Object)"OMGOMGOMG").get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Override
    protected URI getUrlForId(String id) {
        return null;
    }

    @Override
    protected URI getUrlForEntity(AbstractAuthzEntity entity) {
        return null;
    }
}

