/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2ForbiddenException;
import net.krotscheck.kangaroo.authz.admin.v1.auth.filter.OAuth2AuthorizationFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class OAuth2AuthorizationFilterTest {
    private ContainerRequestContext requestContext;
    private SecurityContext securityContext;

    @Before
    public void setup() {
        this.requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        this.securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        UriBuilder mockBuilder = UriBuilder.fromPath((String)"http://example.com/");
        List<String> matchedPaths = Collections.singletonList("path");
        ((ContainerRequestContext)Mockito.doReturn((Object)this.securityContext).when((Object)this.requestContext)).getSecurityContext();
        ((SecurityContext)Mockito.doReturn((Object)false).when((Object)this.securityContext)).isUserInRole("invalid");
        ((SecurityContext)Mockito.doReturn((Object)true).when((Object)this.securityContext)).isUserInRole("valid");
        ((ContainerRequestContext)Mockito.doReturn((Object)mockInfo).when((Object)this.requestContext)).getUriInfo();
        ((UriInfo)Mockito.doReturn((Object)mockBuilder).when((Object)mockInfo)).getBaseUriBuilder();
        ((UriInfo)Mockito.doReturn(matchedPaths).when((Object)mockInfo)).getMatchedURIs();
    }

    @Test
    public void assertCorrectPriority() throws Exception {
        Priority a = OAuth2AuthorizationFilter.class.getAnnotation(Priority.class);
        Assert.assertEquals((long)2000L, (long)a.value());
    }

    @Test
    public void assertValidScopes() throws Exception {
        OAuth2AuthorizationFilter filter = new OAuth2AuthorizationFilter(new String[]{"valid"});
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2ForbiddenException.class)
    public void assertResourceWithNoScopes() throws Exception {
        OAuth2AuthorizationFilter filter = new OAuth2AuthorizationFilter();
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2ForbiddenException.class)
    public void assertNoSecurityContext() throws Exception {
        ((ContainerRequestContext)Mockito.doReturn(null).when((Object)this.requestContext)).getSecurityContext();
        OAuth2AuthorizationFilter filter = new OAuth2AuthorizationFilter();
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2ForbiddenException.class)
    public void assertWithMismatchedScopes() throws Exception {
        OAuth2AuthorizationFilter filter = new OAuth2AuthorizationFilter(new String[]{"invalid"});
        filter.filter(this.requestContext);
    }
}

