/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.filter;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.admin.v1.auth.OAuth2SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2NotAuthorizedException;
import net.krotscheck.kangaroo.authz.admin.v1.auth.filter.OAuth2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class OAuth2AuthenticationFilterTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE;
    private final Provider<Session> sessionProvider = () -> ((OAuth2AuthenticationFilterTest)this).getSession();
    private final Provider<Configuration> configProvider = () -> {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("application_id", IdUtil.toString((BigInteger)context.getApplication().getId()));
        return new MapConfiguration(config);
    };
    private ContainerRequestContext requestContext;
    private SecurityContext securityContext;

    @Test
    public void assertCorrectPriority() throws Exception {
        Priority a = OAuth2AuthenticationFilter.class.getAnnotation(Priority.class);
        Assert.assertEquals((long)1000L, (long)a.value());
    }

    @Before
    public void setup() {
        this.requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        this.securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        UriBuilder mockBuilder = UriBuilder.fromPath((String)"http://example.com/");
        List<String> matchedPaths = Collections.singletonList("path");
        ((ContainerRequestContext)Mockito.doReturn((Object)this.securityContext).when((Object)this.requestContext)).getSecurityContext();
        ((ContainerRequestContext)Mockito.doReturn((Object)mockInfo).when((Object)this.requestContext)).getUriInfo();
        ((UriInfo)Mockito.doReturn((Object)mockBuilder).when((Object)mockInfo)).getBaseUriBuilder();
        ((UriInfo)Mockito.doReturn(matchedPaths).when((Object)mockInfo)).getMatchedURIs();
    }

    @Test
    public void assertValidToken() throws Exception {
        OAuthToken token = context.getBuilder().bearerToken("one").build().getToken();
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        String header = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        ((ContainerRequestContext)Mockito.doReturn((Object)header).when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
        ArgumentCaptor contextCaptor = ArgumentCaptor.forClass(OAuth2SecurityContext.class);
        ((ContainerRequestContext)Mockito.verify((Object)this.requestContext, (VerificationMode)Mockito.times((int)1))).setSecurityContext((SecurityContext)contextCaptor.capture());
        Assert.assertEquals((Object)token, (Object)((OAuth2SecurityContext)contextCaptor.getValue()).getUserPrincipal());
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertNoContext() throws Exception {
        ((ContainerRequestContext)Mockito.doReturn(null).when((Object)this.requestContext)).getSecurityContext();
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertEmptyToken() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        String header = HttpUtil.authHeaderBearer((String)"");
        ((ContainerRequestContext)Mockito.doReturn((Object)header).when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertInvalidToken() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        String header = HttpUtil.authHeaderBearer((BigInteger)IdUtil.next());
        ((ContainerRequestContext)Mockito.doReturn((Object)header).when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertExpiredToken() throws Exception {
        OAuthToken token = context.getBuilder().token(OAuthTokenType.Bearer, true, "one", null, null).build().getToken();
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        String header = HttpUtil.authHeaderBearer((BigInteger)token.getId());
        ((ContainerRequestContext)Mockito.doReturn((Object)header).when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertEmptyHeader() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        ((ContainerRequestContext)Mockito.doReturn((Object)"").when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertBadlyFormattedHeader() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        ((ContainerRequestContext)Mockito.doReturn((Object)"invalid_format").when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertNoBearerHeader() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        ((ContainerRequestContext)Mockito.doReturn((Object)"HMAC Token").when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    @Test(expected=OAuth2NotAuthorizedException.class)
    public void assertBadlyFormedToken() throws Exception {
        OAuth2AuthenticationFilter filter = new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[]{"one"});
        ((ContainerRequestContext)Mockito.doReturn((Object)"Bearer not_a_BigInteger").when((Object)this.requestContext)).getHeaderString("Authorization");
        filter.filter(this.requestContext);
    }

    static {
        TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).role("admin").scope("one").scope("two").client(ClientType.OwnerCredentials).authenticator(AuthenticatorType.Test).user().build();
            }
        };
    }
}

