/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.WWWChallengeException;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class WWWChallengeExceptionTest {
    @Test
    public void assertConstructorWithPath() {
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        List<String> mockPaths = Arrays.asList("foo");
        UriBuilder mockBuilder = UriBuilder.fromUri((String)"http://localhost/");
        ((UriInfo)Mockito.doReturn((Object)mockBuilder).when((Object)mockInfo)).getBaseUriBuilder();
        ((UriInfo)Mockito.doReturn(mockPaths).when((Object)mockInfo)).getMatchedURIs();
        String[] requiredScopes = new String[]{"one", "two"};
        TestException e = new TestException(mockInfo, requiredScopes);
        Assert.assertSame((Object)requiredScopes, (Object)e.getRequiredScopes());
        Assert.assertEquals((Object)"http://localhost/foo", (Object)e.getRealm().toString());
    }

    @Test
    public void assertConstructorWithManyPaths() {
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        List<String> mockPaths = Arrays.asList("one", "two", "three");
        UriBuilder mockBuilder = UriBuilder.fromUri((String)"http://localhost/");
        ((UriInfo)Mockito.doReturn((Object)mockBuilder).when((Object)mockInfo)).getBaseUriBuilder();
        ((UriInfo)Mockito.doReturn(mockPaths).when((Object)mockInfo)).getMatchedURIs();
        String[] requiredScopes = new String[]{"one", "two"};
        TestException e = new TestException(mockInfo, requiredScopes);
        Assert.assertSame((Object)requiredScopes, (Object)e.getRequiredScopes());
        Assert.assertEquals((Object)"http://localhost/three", (Object)e.getRealm().toString());
    }

    @Test
    public void assertConstructorWithNoPaths() {
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList mockPaths = new ArrayList();
        UriBuilder mockBuilder = UriBuilder.fromUri((String)"http://localhost/");
        ((UriInfo)Mockito.doReturn((Object)mockBuilder).when((Object)mockInfo)).getBaseUriBuilder();
        ((UriInfo)Mockito.doReturn(mockPaths).when((Object)mockInfo)).getMatchedURIs();
        String[] requiredScopes = new String[]{"one", "two"};
        TestException e = new TestException(mockInfo, requiredScopes);
        Assert.assertSame((Object)requiredScopes, (Object)e.getRequiredScopes());
        Assert.assertEquals((Object)"http://localhost/", (Object)e.getRealm().toString());
    }

    public static final class TestException
    extends WWWChallengeException {
        public static final KangarooException.ErrorCode CODE = new KangarooException.ErrorCode(Response.Status.UNAUTHORIZED, "test_error", "Test Error");

        protected TestException(UriInfo requestInfo, String[] requiredScopes) {
            super(CODE, requestInfo, requiredScopes);
        }
    }
}

