/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.exception;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.admin.v1.auth.OAuth2AuthFeature;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2ForbiddenException;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2NotAuthorizedException;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.common.jackson.JacksonFeature;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;

public final class WWWChallengeExceptionMapperTest
extends ContainerTest {
    protected ResourceConfig createApplication() {
        ResourceConfig config = new ResourceConfig();
        config.register(ErrorService.class);
        config.register(JacksonFeature.class);
        config.register(ExceptionFeature.class);
        config.register(OAuth2AuthFeature.class);
        return config;
    }

    @Test
    public void test401Serialization() {
        Response r = this.target("/error/401").request().get();
        Assert.assertEquals((long)401L, (long)r.getStatus());
        Map<String, String> headerValues = this.decodeHeader(r.getHeaderString("WWW-Authenticate"));
        Assert.assertEquals((Object)"unauthorized", (Object)headerValues.get("error"));
        Assert.assertEquals((Object)"You are not authorized.", (Object)headerValues.get("error_description"));
        Assert.assertEquals((Object)"one two", (Object)headerValues.get("scope"));
        URI realm = UriBuilder.fromUri((String)headerValues.get("realm")).build(new Object[0]);
        Assert.assertEquals((Object)"/error", (Object)realm.getPath());
    }

    @Test
    public void test403Serialization() {
        Response r = this.target("/error/403").request().get();
        Assert.assertEquals((long)403L, (long)r.getStatus());
        Map<String, String> headerValues = this.decodeHeader(r.getHeaderString("WWW-Authenticate"));
        Assert.assertEquals((Object)"forbidden", (Object)headerValues.get("error"));
        Assert.assertEquals((Object)"This token may not access this resource.", (Object)headerValues.get("error_description"));
        Assert.assertEquals((Object)"one two", (Object)headerValues.get("scope"));
        URI realm = UriBuilder.fromUri((String)headerValues.get("realm")).build(new Object[0]);
        Assert.assertEquals((Object)"/error", (Object)realm.getPath());
    }

    private Map<String, String> decodeHeader(String headerString) {
        Assert.assertTrue((headerString.indexOf("Bearer") == 0 ? 1 : 0) != 0);
        HashMap<String, String> headerValues = new HashMap<String, String>();
        Arrays.stream(headerString.substring(7).split(",")).map(String::trim).map(s -> s.split("=")).peek(s -> {
            s[1] = s[1].substring(1, s[1].length() - 1);
        }).forEach(s -> headerValues.put(s[0], s[1]));
        return headerValues;
    }

    @Path(value="/error")
    public static final class ErrorService {
        @GET
        @Path(value="/401")
        @Produces(value={"application/json"})
        public Response notAuthorized(@Context UriInfo uriInfo) {
            throw new OAuth2NotAuthorizedException(uriInfo, new String[]{"one", "two"});
        }

        @GET
        @Path(value="/403")
        @Produces(value={"application/json"})
        public Response forbidden(@Context UriInfo uriInfo) {
            throw new OAuth2ForbiddenException(uriInfo, new String[]{"one", "two"});
        }
    }
}

