/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth;

import net.krotscheck.kangaroo.authz.admin.v1.auth.OAuth2SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class OAuth2SecurityContextTest
extends DatabaseTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    @Test
    public void getUserPrincipal() throws Exception {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getAdminApplication();
        OAuthToken token = context.getBuilder().scope("principal-1").scope("principal-2").bearerToken("principal-1", "principal-2").build().getToken();
        OAuth2SecurityContext securityContext = new OAuth2SecurityContext(token, Boolean.valueOf(false));
        Assert.assertEquals((Object)false, (Object)securityContext.isSecure());
        Assert.assertEquals((Object)"OAuth2", (Object)securityContext.getAuthenticationScheme());
        Assert.assertSame((Object)token, (Object)securityContext.getUserPrincipal());
        Assert.assertTrue((boolean)securityContext.isUserInRole("principal-1"));
        Assert.assertTrue((boolean)securityContext.isUserInRole("principal-2"));
        Assert.assertFalse((boolean)securityContext.isUserInRole("principal-3"));
    }
}

