/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth;

import java.math.BigInteger;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.OAuth2ScopeDynamicFeature;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class OAuth2ScopeDynamicFeatureTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(DatabaseFeature.class);
        a.register(OAuth2ScopeDynamicFeature.class);
        a.register(MockService.class);
        a.register(SecondMockService.class);
        a.register(ThirdMockService.class);
        a.register(ExceptionFeature.class);
        a.register(ConfigurationFeature.class);
        a.register((Object)new ServletConfigFactory.Binder());
        a.register((Object)new FirstRunContainerLifecycleListener.Binder());
        return a;
    }

    @Test
    public void testDenyAllMethod() {
        Response response = this.target("/first/deny").request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testPermitAllMethod() {
        Response response = this.target("/first/permit").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testValidScopesMethod() {
        OAuthToken token = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().bearerToken("kangaroo:client").build().getToken();
        Response response = this.target("/first/scopes").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testInvalidScopesMethod() {
        OAuthToken token = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().bearerToken("kangaroo:user").build().getToken();
        Response response = this.target("/first/scopes").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).get();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testValidScopesClass() {
        OAuthToken token = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().bearerToken("kangaroo:client").build().getToken();
        Response response = this.target("/second").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testInvalidScopeClass() {
        OAuthToken token = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().bearerToken("kangaroo:user").build().getToken();
        Response response = this.target("/second").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).get();
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testPermitAllClass() {
        OAuthToken token = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().bearerToken("kangaroo:user").build().getToken();
        Response response = this.target("/third").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)token.getId())).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Path(value="/third")
    @PermitAll
    public static final class ThirdMockService {
        @GET
        @Produces(value={"application/json"})
        public Response permitAll() {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    @Path(value="/second")
    @ScopesAllowed(value={"kangaroo:client"})
    public static final class SecondMockService {
        @GET
        @Produces(value={"application/json"})
        public Response permitScopes() {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }

    @Path(value="/first")
    public static final class MockService {
        @GET
        @Path(value="/deny")
        @DenyAll
        @Produces(value={"application/json"})
        public Response denyAll() {
            return Response.status((Response.Status)Response.Status.OK).build();
        }

        @GET
        @Path(value="/permit")
        @PermitAll
        @Produces(value={"application/json"})
        public Response permitAll() {
            return Response.status((Response.Status)Response.Status.OK).build();
        }

        @GET
        @Path(value="/scopes")
        @ScopesAllowed(value={"kangaroo:client"})
        @Produces(value={"application/json"})
        public Response permitScopes() {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
    }
}

