/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import net.krotscheck.kangaroo.authz.admin.Scope;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import org.junit.Assert;
import org.junit.Test;

public final class ScopeTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = Scope.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testExpectedConstants() {
        Assert.assertEquals((Object)"kangaroo:application", (Object)"kangaroo:application");
        Assert.assertEquals((Object)"kangaroo:application_admin", (Object)"kangaroo:application_admin");
        Assert.assertEquals((Object)"kangaroo:authenticator", (Object)"kangaroo:authenticator");
        Assert.assertEquals((Object)"kangaroo:authenticator_admin", (Object)"kangaroo:authenticator_admin");
        Assert.assertEquals((Object)"kangaroo:client", (Object)"kangaroo:client");
        Assert.assertEquals((Object)"kangaroo:client_admin", (Object)"kangaroo:client_admin");
        Assert.assertEquals((Object)"kangaroo:user", (Object)"kangaroo:user");
        Assert.assertEquals((Object)"kangaroo:user_admin", (Object)"kangaroo:user_admin");
        Assert.assertEquals((Object)"kangaroo:role", (Object)"kangaroo:role");
        Assert.assertEquals((Object)"kangaroo:role_admin", (Object)"kangaroo:role_admin");
        Assert.assertEquals((Object)"kangaroo:identity", (Object)"kangaroo:identity");
        Assert.assertEquals((Object)"kangaroo:identity_admin", (Object)"kangaroo:identity_admin");
        Assert.assertEquals((Object)"kangaroo:scope", (Object)"kangaroo:scope");
        Assert.assertEquals((Object)"kangaroo:scope_admin", (Object)"kangaroo:scope_admin");
        Assert.assertEquals((Object)"kangaroo:token", (Object)"kangaroo:token");
        Assert.assertEquals((Object)"kangaroo:token_admin", (Object)"kangaroo:token_admin");
    }

    @Test
    public void testAllScopeList() {
        List allScopes = Scope.allScopes();
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:application"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:application_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:authenticator"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:authenticator_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:client"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:client_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:user"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:user_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:role"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:role_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:identity"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:identity_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:scope"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:scope_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:token"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:token_admin"));
        Assert.assertEquals((long)16L, (long)allScopes.size());
    }

    @Test
    public void testAdminScopeList() {
        List allScopes = Scope.adminScopes();
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:application"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:application_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:authenticator"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:authenticator_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:client"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:client_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:user"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:user_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:role"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:role_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:identity"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:identity_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:scope"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:scope_admin"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:token"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:token_admin"));
        Assert.assertEquals((long)8L, (long)allScopes.size());
    }

    @Test
    public void testUserScopeList() {
        List allScopes = Scope.userScopes();
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:application"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:application_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:authenticator"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:authenticator_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:client"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:client_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:user"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:user_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:role"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:role_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:identity"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:identity_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:scope"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:scope_admin"));
        Assert.assertTrue((boolean)allScopes.contains("kangaroo:token"));
        Assert.assertFalse((boolean)allScopes.contains("kangaroo:token_admin"));
        Assert.assertEquals((long)8L, (long)allScopes.size());
    }

    @Test
    public void testGetScopeForEntity() {
        Assert.assertEquals((Object)"kangaroo:application", (Object)Scope.forEntity((AbstractAuthzEntity)new Application(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:application_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new Application(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:authenticator", (Object)Scope.forEntity((AbstractAuthzEntity)new Authenticator(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:authenticator_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new Authenticator(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:client", (Object)Scope.forEntity((AbstractAuthzEntity)new Client(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:client_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new Client(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:user", (Object)Scope.forEntity((AbstractAuthzEntity)new User(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:user_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new User(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:role", (Object)Scope.forEntity((AbstractAuthzEntity)new Role(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:role_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new Role(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:identity", (Object)Scope.forEntity((AbstractAuthzEntity)new UserIdentity(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:identity_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new UserIdentity(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:scope", (Object)Scope.forEntity((AbstractAuthzEntity)new ApplicationScope(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:scope_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new ApplicationScope(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:token", (Object)Scope.forEntity((AbstractAuthzEntity)new OAuthToken(), (Boolean)false));
        Assert.assertEquals((Object)"kangaroo:token_admin", (Object)Scope.forEntity((AbstractAuthzEntity)new OAuthToken(), (Boolean)true));
        Assert.assertEquals((Object)"kangaroo:unknown", (Object)Scope.forEntity(null, (Boolean)true));
    }
}

