/**
 * Licensed to the KPipes under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kpipes.function.count

import net.kpipes.core.function.Event
import net.kpipes.core.function.EventAggregateFunction

class CountFunctionTable implements EventAggregateFunction {

    @Override
    Map<String, Object> onEvent(Event event, Map<String, Object> accumulator) {
        def current = accumulator.getOrDefault('count', 0)
        [count: event.added() ? current + 1 : current - 1]
    }

}