/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.usage;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import net.kautler.command.usage.UsageBaseVisitor;
import net.kautler.command.usage.UsageParser;
import net.kautler.command.usage.UsageParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

@ApplicationScoped
public class UsagePatternBuilder
extends UsageBaseVisitor<String> {
    private static final String PARAMETER_BOUNDARY_PATTERN_PART = String.format("(?:(?<!^)%s++(?!$))?", "[\\s&&[^\\n]]");
    private static final String PRECEDED_BY_PARAMETER_SEPARATOR_CHARACTER = String.format("(?<=^|(?<!^)%s)", "[\\s&&[^\\n]]");
    private static final String FOLLOWED_BY_PARAMETER_SEPARATOR_CHARACTER = String.format("(?=%s(?!$)|$)", "[\\s&&[^\\n]]");
    private final Map<UsageParser.UsageContext, Pattern> patternCache = new ConcurrentHashMap<UsageParser.UsageContext, Pattern>();
    private final Map<UsageParser.UsageContext, Map<String, List<String>>> groupNamesBySanitizedTokenNameByUsageContext = new ConcurrentHashMap<UsageParser.UsageContext, Map<String, List<String>>>();
    private final Map<UsageParser.UsageContext, Map<String, List<String>>> groupNamesByTokenNameByUsageContext = new ConcurrentHashMap<UsageParser.UsageContext, Map<String, List<String>>>();

    private UsagePatternBuilder() {
    }

    public Pattern getPattern(UsageParser.UsageContext usageTree) {
        return this.patternCache.computeIfAbsent(usageTree, key -> {
            Pattern result = Pattern.compile(this.visitUsage(usageTree));
            this.groupNamesBySanitizedTokenNameByUsageContext.remove((Object)usageTree);
            return result;
        });
    }

    public Map<String, List<String>> getGroupNamesByTokenName(UsageParser.UsageContext usageTree) {
        return this.groupNamesByTokenNameByUsageContext.computeIfAbsent(usageTree, key -> new ConcurrentHashMap());
    }

    @Override
    public String visitUsage(UsageParser.UsageContext ctx) {
        return this.visitParentParserRuleContext(ctx);
    }

    @Override
    public String visitAlternatives(UsageParser.AlternativesContext ctx) {
        return ctx.alternativesSubExpression().stream().map(this::visitParentParserRuleContext).collect(Collectors.joining("|", "(?:", ")"));
    }

    @Override
    public String visitOptional(UsageParser.OptionalContext ctx) {
        return String.format("(?:%s)?", this.visitParentParserRuleContext(ctx.optionalSubExpression()));
    }

    private String visitParentParserRuleContext(UsageParserRuleContext ctx) {
        Optional<ParseTree> singleChild = ctx.getSingleChild();
        if (singleChild.isPresent()) {
            return (String)singleChild.get().accept((ParseTreeVisitor)this);
        }
        List<UsageParser.ExpressionContext> expressions = ctx.expression();
        if (expressions.isEmpty()) {
            throw new AssertionError((Object)"Unhandled case");
        }
        return expressions.stream().map(this::visitParentParserRuleContext).collect(Collectors.joining(PARAMETER_BOUNDARY_PATTERN_PART));
    }

    @Override
    public String visitPlaceholder(UsageParser.PlaceholderContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 1);
        return String.format("%s(?<%s>\\S+)%s", PRECEDED_BY_PARAMETER_SEPARATOR_CHARACTER, this.getGroupName(ctx, tokenName), FOLLOWED_BY_PARAMETER_SEPARATOR_CHARACTER);
    }

    @Override
    public String visitPlaceholderWithWhitespace(UsageParser.PlaceholderWithWhitespaceContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 4);
        return String.format("%s(?<%s>.+)$", PRECEDED_BY_PARAMETER_SEPARATOR_CHARACTER, this.getGroupName(ctx, tokenName));
    }

    @Override
    public String visitLiteral(UsageParser.LiteralContext ctx) {
        String tokenText = ctx.getText();
        String tokenName = tokenText.substring(1, tokenText.length() - 1);
        return String.format("%s(?<%s>%s)%s", PRECEDED_BY_PARAMETER_SEPARATOR_CHARACTER, this.getGroupName(ctx, tokenName, "Literal"), Pattern.quote(tokenName), FOLLOWED_BY_PARAMETER_SEPARATOR_CHARACTER);
    }

    private String getGroupName(UsageParserRuleContext ctx, String tokenName) {
        return this.getGroupName(ctx, tokenName, "");
    }

    private String getGroupName(UsageParserRuleContext ctx, String tokenName, String groupNameSuffix) {
        UsageParser.UsageContext usageContext = this.getUsageContext(ctx);
        String sanitizedTokenName = tokenName.replaceAll("\\P{Alnum}++", "") + groupNameSuffix;
        String[] groupName = new String[1];
        this.groupNamesBySanitizedTokenNameByUsageContext.computeIfAbsent(usageContext, key -> new ConcurrentHashMap()).compute(sanitizedTokenName, (key, value) -> {
            if (value == null) {
                value = new CopyOnWriteArrayList<String>();
            }
            groupName[0] = key + value.size();
            value.add(groupName[0]);
            return value;
        });
        this.groupNamesByTokenNameByUsageContext.computeIfAbsent(usageContext, key -> new ConcurrentHashMap()).computeIfAbsent(tokenName, key -> new CopyOnWriteArrayList()).add(groupName[0]);
        return groupName[0];
    }

    private UsageParser.UsageContext getUsageContext(UsageParserRuleContext ctx) {
        UsageParserRuleContext current = ctx;
        while (!(current instanceof UsageParser.UsageContext)) {
            current = current.getParent();
        }
        return (UsageParser.UsageContext)current;
    }

    public String toString() {
        return new StringJoiner(", ", UsagePatternBuilder.class.getSimpleName() + "[", "]").add("patternCache=" + this.patternCache).add("groupNamesBySanitizedTokenNameByUsageContext=" + this.groupNamesBySanitizedTokenNameByUsageContext).add("groupNamesByTokenNameByUsageContext=" + this.groupNamesByTokenNameByUsageContext).toString();
    }
}

