/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.restriction;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kautler.command.api.restriction.Restriction;

public class RestrictionLookup<M> {
    private final Set<Restriction<? super M>> restrictions = new CopyOnWriteArraySet<Restriction<? super M>>();
    private final Map<Class<?>, Restriction<? super M>> restrictionByClass = new ConcurrentHashMap();

    public void addAllRestrictions(Collection<Restriction<? super M>> restrictions) {
        this.restrictions.addAll(restrictions);
        this.restrictionByClass.clear();
    }

    public Restriction<? super M> getRestriction(Class<?> restrictionClass) {
        return this.restrictionByClass.computeIfAbsent(restrictionClass, key -> this.restrictions.stream().filter(key::isInstance).min(Comparator.comparingInt(restriction -> RestrictionLookup.getInheritanceDistance(restriction, key))).orElse(null));
    }

    private static int getInheritanceDistance(Restriction<?> restriction, Class<?> restrictionClass) {
        int distance = 0;
        Class<?> clazz = restriction.getClass();
        while (!clazz.equals(restrictionClass) && restrictionClass.isAssignableFrom(clazz)) {
            ++distance;
            clazz = clazz.getSuperclass();
        }
        return distance;
    }

    public String toString() {
        return new StringJoiner(", ", RestrictionLookup.class.getSimpleName() + "[", "]").add("restrictions=" + this.restrictions).add("restrictionByClass=" + this.restrictionByClass).toString();
    }
}

