/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api.restriction.javacord;

import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.kautler.command.api.restriction.Restriction;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Nameable;
import org.javacord.api.entity.message.Message;

public abstract class ServerJavacord
implements Restriction<Message> {
    private final long serverId;
    private final String serverName;
    private final boolean caseSensitive;
    private final Pattern serverPattern;

    protected ServerJavacord(long serverId) {
        this(serverId, null, true, null);
    }

    protected ServerJavacord(String serverName) {
        this(0L, serverName, true, null);
    }

    protected ServerJavacord(String serverName, boolean caseSensitive) {
        this(0L, serverName, caseSensitive, null);
    }

    protected ServerJavacord(Pattern serverPattern) {
        this(0L, null, true, serverPattern);
    }

    private ServerJavacord(long serverId, String serverName, boolean caseSensitive, Pattern serverPattern) {
        this.serverId = serverId;
        this.serverName = serverName;
        this.caseSensitive = caseSensitive;
        this.serverPattern = serverPattern;
        this.ensureInvariants();
    }

    private void ensureInvariants() {
        this.ensureAtMostOneConditionIsSet();
        this.ensureAtLeastOneConditionIsSet();
        this.ensureCaseSensitiveIfNameIsNotSet();
    }

    private void ensureAtMostOneConditionIsSet() {
        boolean multipleConditionsSet;
        boolean serverIdSet = this.serverId != 0L;
        boolean serverNameSet = this.serverName != null;
        boolean serverPatternSet = this.serverPattern != null;
        boolean serverNamelySet = serverNameSet || serverPatternSet;
        boolean serverIdAndNamelySet = serverIdSet && serverNamelySet;
        boolean bothServerNamelySet = serverNameSet && serverPatternSet;
        boolean bl = multipleConditionsSet = serverIdAndNamelySet || bothServerNamelySet;
        if (multipleConditionsSet) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            if (serverIdSet) {
                stringJoiner.add("serverId");
            }
            if (serverNameSet) {
                stringJoiner.add("serverName");
            }
            if (serverPatternSet) {
                stringJoiner.add("serverPattern");
            }
            throw new IllegalStateException(String.format("Only one of serverId, serverName and serverPattern should be given (%s)", stringJoiner));
        }
    }

    private void ensureAtLeastOneConditionIsSet() {
        boolean atLeastOneConditionSet;
        boolean serverIdSet = this.serverId != 0L;
        boolean serverNameSet = this.serverName != null;
        boolean serverPatternSet = this.serverPattern != null;
        boolean serverNamelySet = serverNameSet || serverPatternSet;
        boolean bl = atLeastOneConditionSet = serverIdSet || serverNamelySet;
        if (!atLeastOneConditionSet) {
            throw new IllegalStateException("One of serverId, serverName and serverPattern should be given");
        }
    }

    private void ensureCaseSensitiveIfNameIsNotSet() {
        if (this.serverName == null && !this.caseSensitive) {
            throw new IllegalStateException("If serverName is not set, caseSensitive should be true");
        }
    }

    @Override
    public boolean allowCommand(Message message) {
        return this.serverName == null && this.serverPattern == null ? this.allowCommandByServerId(message) : this.allowCommandByServerName(message);
    }

    private boolean allowCommandByServerId(Message message) {
        return message.getServer().map(DiscordEntity::getId).map(serverId -> serverId == this.serverId).orElse(Boolean.FALSE);
    }

    private boolean allowCommandByServerName(Message message) {
        return message.getServer().map(Nameable::getName).map(serverName -> {
            if (this.serverName == null) {
                return this.serverPattern.matcher((CharSequence)serverName).matches();
            }
            if (this.caseSensitive) {
                return this.serverName.equals(serverName);
            }
            return this.serverName.equalsIgnoreCase((String)serverName);
        }).orElse(Boolean.FALSE);
    }
}

