/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api.restriction.javacord;

import java.util.Collection;
import java.util.Comparator;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kautler.command.api.restriction.Restriction;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Nameable;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.server.Server;

public abstract class RoleJavacord
implements Restriction<Message> {
    private final boolean exact;
    private final long roleId;
    private final String roleName;
    private final boolean caseSensitive;
    private final Pattern rolePattern;

    protected RoleJavacord(long roleId) {
        this(true, roleId, null, true, null);
    }

    protected RoleJavacord(String roleName) {
        this(true, 0L, roleName, true, null);
    }

    protected RoleJavacord(String roleName, boolean caseSensitive) {
        this(true, 0L, roleName, caseSensitive, null);
    }

    protected RoleJavacord(Pattern rolePattern) {
        this(true, 0L, null, true, rolePattern);
    }

    protected RoleJavacord(boolean exact, long roleId) {
        this(exact, roleId, null, true, null);
    }

    protected RoleJavacord(boolean exact, String roleName) {
        this(exact, 0L, roleName, true, null);
    }

    protected RoleJavacord(boolean exact, String roleName, boolean caseSensitive) {
        this(exact, 0L, roleName, caseSensitive, null);
    }

    protected RoleJavacord(boolean exact, Pattern rolePattern) {
        this(exact, 0L, null, true, rolePattern);
    }

    private RoleJavacord(boolean exact, long roleId, String roleName, boolean caseSensitive, Pattern rolePattern) {
        this.exact = exact;
        this.roleId = roleId;
        this.roleName = roleName;
        this.caseSensitive = caseSensitive;
        this.rolePattern = rolePattern;
        this.ensureInvariants();
    }

    private void ensureInvariants() {
        this.ensureAtMostOneConditionIsSet();
        this.ensureAtLeastOneConditionIsSet();
        this.ensureCaseSensitiveIfNameIsNotSet();
    }

    private void ensureAtMostOneConditionIsSet() {
        boolean multipleConditionsSet;
        boolean roleIdSet = this.roleId != 0L;
        boolean roleNameSet = this.roleName != null;
        boolean rolePatternSet = this.rolePattern != null;
        boolean roleNamelySet = roleNameSet || rolePatternSet;
        boolean roleIdAndNamelySet = roleIdSet && roleNamelySet;
        boolean bothRoleNamelySet = roleNameSet && rolePatternSet;
        boolean bl = multipleConditionsSet = roleIdAndNamelySet || bothRoleNamelySet;
        if (multipleConditionsSet) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            if (roleIdSet) {
                stringJoiner.add("roleId");
            }
            if (roleNameSet) {
                stringJoiner.add("roleName");
            }
            if (rolePatternSet) {
                stringJoiner.add("rolePattern");
            }
            throw new IllegalStateException(String.format("Only one of roleId, roleName and rolePattern should be given (%s)", stringJoiner));
        }
    }

    private void ensureAtLeastOneConditionIsSet() {
        boolean atLeastOneConditionSet;
        boolean roleIdSet = this.roleId != 0L;
        boolean roleNameSet = this.roleName != null;
        boolean rolePatternSet = this.rolePattern != null;
        boolean roleNamelySet = roleNameSet || rolePatternSet;
        boolean bl = atLeastOneConditionSet = roleIdSet || roleNamelySet;
        if (!atLeastOneConditionSet) {
            throw new IllegalStateException("One of roleId, roleName and rolePattern should be given");
        }
    }

    private void ensureCaseSensitiveIfNameIsNotSet() {
        if (this.roleName == null && !this.caseSensitive) {
            throw new IllegalStateException("If roleName is not set, caseSensitive should be true");
        }
    }

    @Override
    public boolean allowCommand(Message message) {
        return this.roleName == null && this.rolePattern == null ? this.allowCommandByRoleId(message) : this.allowCommandByRoleName(message);
    }

    private boolean allowCommandByRoleId(Message message) {
        return this.exact ? this.allowCommandByExactRoleId(message) : this.allowCommandByAtLeastRoleId(message);
    }

    private boolean allowCommandByExactRoleId(Message message) {
        return message.getServer().flatMap(server -> message.getUserAuthor().map(arg_0 -> ((Server)server).getRoles(arg_0))).map(Collection::stream).map(roles -> roles.mapToLong(DiscordEntity::getId)).map(roleIds -> roleIds.anyMatch(roleId -> roleId == this.roleId)).orElse(Boolean.FALSE);
    }

    private boolean allowCommandByAtLeastRoleId(Message message) {
        return message.getServer().flatMap(server -> server.getRoleById(this.roleId).flatMap(role -> message.getUserAuthor().flatMap(arg_0 -> ((Server)server).getHighestRole(arg_0)).map(highestAuthorRole -> highestAuthorRole.compareTo(role) >= 0))).orElse(Boolean.FALSE);
    }

    private boolean allowCommandByRoleName(Message message) {
        return this.exact ? this.allowCommandByExactRoleName(message) : this.allowCommandByAtLeastRoleName(message);
    }

    private boolean allowCommandByExactRoleName(Message message) {
        return message.getServer().flatMap(server -> message.getUserAuthor().map(arg_0 -> ((Server)server).getRoles(arg_0))).map(Collection::stream).map(roles -> roles.map(Nameable::getName)).map(roleNames -> roleNames.anyMatch(roleName -> {
            if (this.roleName == null) {
                return this.rolePattern.matcher((CharSequence)roleName).matches();
            }
            if (this.caseSensitive) {
                return this.roleName.equals(roleName);
            }
            return this.roleName.equalsIgnoreCase((String)roleName);
        })).orElse(Boolean.FALSE);
    }

    private boolean allowCommandByAtLeastRoleName(Message message) {
        return message.getServer().flatMap(server -> {
            Stream<Object> roleStream = this.roleName == null ? server.getRoles().stream().filter(role -> this.rolePattern.matcher(role.getName()).matches()) : (this.caseSensitive ? server.getRolesByName(this.roleName).stream() : server.getRolesByNameIgnoreCase(this.roleName).stream());
            return roleStream.min(Comparator.naturalOrder()).flatMap(role -> message.getUserAuthor().flatMap(arg_0 -> ((Server)server).getHighestRole(arg_0)).map(highestAuthorRole -> highestAuthorRole.compareTo(role) >= 0));
        }).orElse(Boolean.FALSE);
    }
}

