/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api.restriction.javacord;

import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.kautler.command.api.restriction.Restriction;
import org.javacord.api.entity.Nameable;
import org.javacord.api.entity.message.Message;

public abstract class ChannelJavacord
implements Restriction<Message> {
    private final long channelId;
    private final String channelName;
    private final boolean caseSensitive;
    private final Pattern channelPattern;

    protected ChannelJavacord(long channelId) {
        this(channelId, null, true, null);
    }

    protected ChannelJavacord(String channelName) {
        this(0L, channelName, true, null);
    }

    protected ChannelJavacord(String channelName, boolean caseSensitive) {
        this(0L, channelName, caseSensitive, null);
    }

    protected ChannelJavacord(Pattern channelPattern) {
        this(0L, null, true, channelPattern);
    }

    private ChannelJavacord(long channelId, String channelName, boolean caseSensitive, Pattern channelPattern) {
        this.channelId = channelId;
        this.channelName = channelName;
        this.caseSensitive = caseSensitive;
        this.channelPattern = channelPattern;
        this.ensureInvariants();
    }

    private void ensureInvariants() {
        this.ensureAtMostOneConditionIsSet();
        this.ensureAtLeastOneConditionIsSet();
        this.ensureCaseSensitiveIfNameIsNotSet();
    }

    private void ensureAtMostOneConditionIsSet() {
        boolean multipleConditionsSet;
        boolean channelIdSet = this.channelId != 0L;
        boolean channelNameSet = this.channelName != null;
        boolean channelPatternSet = this.channelPattern != null;
        boolean channelNamelySet = channelNameSet || channelPatternSet;
        boolean channelIdAndNamelySet = channelIdSet && channelNamelySet;
        boolean bothChannelNamelySet = channelNameSet && channelPatternSet;
        boolean bl = multipleConditionsSet = channelIdAndNamelySet || bothChannelNamelySet;
        if (multipleConditionsSet) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            if (channelIdSet) {
                stringJoiner.add("channelId");
            }
            if (channelNameSet) {
                stringJoiner.add("channelName");
            }
            if (channelPatternSet) {
                stringJoiner.add("channelPattern");
            }
            throw new IllegalStateException(String.format("Only one of channelId, channelName and channelPattern should be given (%s)", stringJoiner));
        }
    }

    private void ensureAtLeastOneConditionIsSet() {
        boolean atLeastOneConditionSet;
        boolean channelIdSet = this.channelId != 0L;
        boolean channelNameSet = this.channelName != null;
        boolean channelPatternSet = this.channelPattern != null;
        boolean channelNamelySet = channelNameSet || channelPatternSet;
        boolean bl = atLeastOneConditionSet = channelIdSet || channelNamelySet;
        if (!atLeastOneConditionSet) {
            throw new IllegalStateException("One of channelId, channelName and channelPattern should be given");
        }
    }

    private void ensureCaseSensitiveIfNameIsNotSet() {
        if (this.channelName == null && !this.caseSensitive) {
            throw new IllegalStateException("If channelName is not set, caseSensitive should be true");
        }
    }

    @Override
    public boolean allowCommand(Message message) {
        return this.channelName == null && this.channelPattern == null ? this.allowCommandByChannelId(message) : this.allowCommandByChannelName(message);
    }

    private boolean allowCommandByChannelId(Message message) {
        return message.getChannel().getId() == this.channelId;
    }

    private boolean allowCommandByChannelName(Message message) {
        return message.getChannel().asServerChannel().map(Nameable::getName).map(channelName -> {
            if (this.channelName == null) {
                return this.channelPattern.matcher((CharSequence)channelName).matches();
            }
            if (this.caseSensitive) {
                return this.channelName.equals(channelName);
            }
            return this.channelName.equalsIgnoreCase((String)channelName);
        }).orElse(Boolean.FALSE);
    }
}

