/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api.restriction;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import net.kautler.command.api.restriction.Restriction;
import net.kautler.command.restriction.RestrictionLookup;

public class RestrictionChainElement {
    private final Class<? extends Restriction<?>> restriction;

    RestrictionChainElement() {
        this.restriction = null;
    }

    public RestrictionChainElement(Class<? extends Restriction<?>> restriction) {
        this.restriction = Objects.requireNonNull(restriction);
    }

    public <M> boolean isCommandAllowed(M message, RestrictionLookup<? super M> availableRestrictions) {
        Restriction<M> restriction = availableRestrictions.getRestriction(this.restriction);
        if (restriction == null) {
            throw new IllegalArgumentException(String.format("The restriction '%s' was not found in the given available restrictions '%s'", this.restriction, availableRestrictions));
        }
        return restriction.allowCommand(message);
    }

    public RestrictionChainElement and(RestrictionChainElement other) {
        return new AndCombination(this, other);
    }

    public RestrictionChainElement and(Class<? extends Restriction<?>> other) {
        return new AndCombination(this, new RestrictionChainElement(other));
    }

    public RestrictionChainElement or(RestrictionChainElement other) {
        return new OrCombination(this, other);
    }

    public RestrictionChainElement or(Class<? extends Restriction<?>> other) {
        return new OrCombination(this, new RestrictionChainElement(other));
    }

    public RestrictionChainElement negate() {
        return new Negation(this);
    }

    public String toString() {
        return new StringJoiner(", ", RestrictionChainElement.class.getSimpleName() + "[", "]").add("restriction=" + this.restriction).toString();
    }

    private static class Negation
    extends RestrictionChainElement {
        private final RestrictionChainElement negated;

        private Negation(RestrictionChainElement negated) {
            this.negated = negated;
        }

        @Override
        public <M> boolean isCommandAllowed(M message, RestrictionLookup<? super M> availableRestrictions) {
            return !this.negated.isCommandAllowed(message, availableRestrictions);
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", Negation.class.getSimpleName() + "[", "]").add("negated=" + this.negated).toString();
        }
    }

    private static class OrCombination
    extends RestrictionChainElement {
        private final RestrictionChainElement left;
        private final RestrictionChainElement right;

        private OrCombination(RestrictionChainElement left, RestrictionChainElement right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public <M> boolean isCommandAllowed(M message, RestrictionLookup<? super M> availableRestrictions) {
            return Stream.of(this.left, this.right).anyMatch(chainElement -> chainElement.isCommandAllowed(message, availableRestrictions));
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", OrCombination.class.getSimpleName() + "[", "]").add("left=" + this.left).add("right=" + this.right).toString();
        }
    }

    private static class AndCombination
    extends RestrictionChainElement {
        private final RestrictionChainElement left;
        private final RestrictionChainElement right;

        private AndCombination(RestrictionChainElement left, RestrictionChainElement right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public <M> boolean isCommandAllowed(M message, RestrictionLookup<? super M> availableRestrictions) {
            return Stream.of(this.left, this.right).allMatch(chainElement -> chainElement.isCommandAllowed(message, availableRestrictions));
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", AndCombination.class.getSimpleName() + "[", "]").add("left=" + this.left).add("right=" + this.right).toString();
        }
    }
}

