/*
 * Decompiled with CFR 0.152.
 */
package net.kautler.command.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Properties;
import java.util.StringJoiner;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class Version {
    private static final URL versionPropertiesResource = Version.class.getResource("../version.properties");
    private final String version;
    private final String commitId;
    private final Instant buildTimestamp;
    private final String displayVersion;

    public Version() {
        Properties versionProperties = new Properties();
        try (InputStream versionPropertiesStream2 = versionPropertiesResource.openStream();){
            versionProperties.load(versionPropertiesStream2);
        }
        catch (IOException versionPropertiesStream2) {
            // empty catch block
        }
        String version = versionProperties.getProperty("version", "$version");
        this.version = version = "$version".equals(version) ? "<unknown>" : version;
        String commitId = versionProperties.getProperty("commitId", "$commitId");
        this.commitId = "$commitId".equals(commitId) ? "<unknown>" : commitId;
        String buildTimestamp = versionProperties.getProperty("buildTimestamp", "$buildTimestamp");
        this.buildTimestamp = "$buildTimestamp".equals(buildTimestamp) ? null : Instant.parse(buildTimestamp);
        this.displayVersion = version.endsWith("-SNAPSHOT") ? String.format("%s [%s | %s]", version, commitId, buildTimestamp) : version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public Instant getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public String toString() {
        return new StringJoiner(", ", Version.class.getSimpleName() + "[", "]").add("version='" + this.version + "'").add("commitId='" + this.commitId + "'").add("buildTimestamp=" + this.buildTimestamp).add("displayVersion='" + this.displayVersion + "'").toString();
    }
}

